@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.JobStorageAccountArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.AuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties that are associated with an Azure Storage account with MSI
 * @property accountKey The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
 * @property accountName The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
 * @property authenticationMode Authentication Mode.
 */
public data class JobStorageAccountArgs(
    public val accountKey: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val authenticationMode: Output<Either<String, AuthenticationMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.JobStorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.JobStorageAccountArgs =
        com.pulumi.azurenative.streamanalytics.inputs.JobStorageAccountArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [JobStorageAccountArgs].
 */
@PulumiTagMarker
public class JobStorageAccountArgsBuilder internal constructor() {
    private var accountKey: Output<String>? = null

    private var accountName: Output<String>? = null

    private var authenticationMode: Output<Either<String, AuthenticationMode>>? = null

    /**
     * @param value The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ornviqxuisdeimac")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("aotlcebepuwbtwdi")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("nsacnvscqhulurrj")
    public suspend fun authenticationMode(`value`: Output<Either<String, AuthenticationMode>>) {
        this.authenticationMode = value
    }

    /**
     * @param value The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("stjbyfsetwbduvjw")
    public suspend fun accountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("gmhfoueysjvntndk")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("arjvkinyqvqmabfb")
    public suspend fun authenticationMode(`value`: Either<String, AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("netkjmotrxhakrhc")
    public fun authenticationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("wtaijehntcrxcjen")
    public fun authenticationMode(`value`: AuthenticationMode) {
        val toBeMapped = Either.ofRight<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    internal fun build(): JobStorageAccountArgs = JobStorageAccountArgs(
        accountKey = accountKey,
        accountName = accountName,
        authenticationMode = authenticationMode,
    )
}
