@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.OutputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An output object, containing all information associated with the named output. All outputs are contained under a streaming job.
 * @property datasource Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
 * @property name Resource name
 * @property serialization Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
 * @property sizeWindow The size window to constrain a Stream Analytics output to.
 * @property timeWindow The time frame for filtering Stream Analytics job outputs.
 */
public data class OutputArgs(
    public val datasource: Output<Any>? = null,
    public val name: Output<String>? = null,
    public val serialization: Output<Any>? = null,
    public val sizeWindow: Output<Int>? = null,
    public val timeWindow: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.OutputArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.OutputArgs =
        com.pulumi.azurenative.streamanalytics.inputs.OutputArgs.builder()
            .datasource(datasource?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .serialization(serialization?.applyValue({ args0 -> args0 }))
            .sizeWindow(sizeWindow?.applyValue({ args0 -> args0 }))
            .timeWindow(timeWindow?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OutputArgs].
 */
@PulumiTagMarker
public class OutputArgsBuilder internal constructor() {
    private var datasource: Output<Any>? = null

    private var name: Output<String>? = null

    private var serialization: Output<Any>? = null

    private var sizeWindow: Output<Int>? = null

    private var timeWindow: Output<String>? = null

    /**
     * @param value Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("jblfrwkrlyjmcwaj")
    public suspend fun datasource(`value`: Output<Any>) {
        this.datasource = value
    }

    /**
     * @param value Resource name
     */
    @JvmName("punwctfjjqbtqoog")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("egqgumfjvwprpajt")
    public suspend fun serialization(`value`: Output<Any>) {
        this.serialization = value
    }

    /**
     * @param value The size window to constrain a Stream Analytics output to.
     */
    @JvmName("gfltyqtkaqxajtpx")
    public suspend fun sizeWindow(`value`: Output<Int>) {
        this.sizeWindow = value
    }

    /**
     * @param value The time frame for filtering Stream Analytics job outputs.
     */
    @JvmName("jxcruwlpdefunidl")
    public suspend fun timeWindow(`value`: Output<String>) {
        this.timeWindow = value
    }

    /**
     * @param value Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("nwysigbwfkqbgnos")
    public suspend fun datasource(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasource = mapped
    }

    /**
     * @param value Resource name
     */
    @JvmName("tieoyvusyrrpafjs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("xfdlaoakfoywrgwt")
    public suspend fun serialization(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialization = mapped
    }

    /**
     * @param value The size window to constrain a Stream Analytics output to.
     */
    @JvmName("vxfmuiwfmjjdixmk")
    public suspend fun sizeWindow(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeWindow = mapped
    }

    /**
     * @param value The time frame for filtering Stream Analytics job outputs.
     */
    @JvmName("yinnyqdldqlennri")
    public suspend fun timeWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeWindow = mapped
    }

    internal fun build(): OutputArgs = OutputArgs(
        datasource = datasource,
        name = name,
        serialization = serialization,
        sizeWindow = sizeWindow,
        timeWindow = timeWindow,
    )
}
