@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.ScalarFunctionPropertiesArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties that are associated with a scalar function.
 * @property binding The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
 * @property inputs
 * @property output Describes the output of a function.
 * @property type Indicates the type of function.
 * Expected value is 'Scalar'.
 */
public data class ScalarFunctionPropertiesArgs(
    public val binding:
    Output<Either<AzureMachineLearningWebServiceFunctionBindingArgs, JavaScriptFunctionBindingArgs>>? =
        null,
    public val inputs: Output<List<FunctionInputArgs>>? = null,
    public val output: Output<FunctionOutputArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.ScalarFunctionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.ScalarFunctionPropertiesArgs =
        com.pulumi.azurenative.streamanalytics.inputs.ScalarFunctionPropertiesArgs.builder()
            .binding(
                binding?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .inputs(inputs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .output(output?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalarFunctionPropertiesArgs].
 */
@PulumiTagMarker
public class ScalarFunctionPropertiesArgsBuilder internal constructor() {
    private var binding:
        Output<Either<AzureMachineLearningWebServiceFunctionBindingArgs, JavaScriptFunctionBindingArgs>>? =
        null

    private var inputs: Output<List<FunctionInputArgs>>? = null

    private var output: Output<FunctionOutputArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
     */
    @JvmName("acuupndmeifrjuhb")
    public suspend
    fun binding(`value`: Output<Either<AzureMachineLearningWebServiceFunctionBindingArgs, JavaScriptFunctionBindingArgs>>) {
        this.binding = value
    }

    /**
     * @param value
     */
    @JvmName("pkyjoalpmbykqrfj")
    public suspend fun inputs(`value`: Output<List<FunctionInputArgs>>) {
        this.inputs = value
    }

    @JvmName("ksmewdqidlnqxyor")
    public suspend fun inputs(vararg values: Output<FunctionInputArgs>) {
        this.inputs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("tcdgkjgcnipdqlxs")
    public suspend fun inputs(values: List<Output<FunctionInputArgs>>) {
        this.inputs = Output.all(values)
    }

    /**
     * @param value Describes the output of a function.
     */
    @JvmName("suiggennfxcvpvdj")
    public suspend fun output(`value`: Output<FunctionOutputArgs>) {
        this.output = value
    }

    /**
     * @param value Indicates the type of function.
     * Expected value is 'Scalar'.
     */
    @JvmName("tdmmyemkfwuytscc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
     */
    @JvmName("qhhtqnqvlwcfkdcm")
    public suspend
    fun binding(`value`: Either<AzureMachineLearningWebServiceFunctionBindingArgs, JavaScriptFunctionBindingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.binding = mapped
    }

    /**
     * @param value The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
     */
    @JvmName("qkxdjwvngibxckwf")
    public fun binding(`value`: AzureMachineLearningWebServiceFunctionBindingArgs) {
        val toBeMapped = Either.ofLeft<AzureMachineLearningWebServiceFunctionBindingArgs,
            JavaScriptFunctionBindingArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.binding = mapped
    }

    /**
     * @param value The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
     */
    @JvmName("fkqbljpgqegfvavm")
    public fun binding(`value`: JavaScriptFunctionBindingArgs) {
        val toBeMapped = Either.ofRight<AzureMachineLearningWebServiceFunctionBindingArgs,
            JavaScriptFunctionBindingArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.binding = mapped
    }

    /**
     * @param value
     */
    @JvmName("nmjcocykacmkibmj")
    public suspend fun inputs(`value`: List<FunctionInputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pwbfgelirjxacvor")
    public suspend fun inputs(argument: List<suspend FunctionInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FunctionInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uferlckbtnawscxk")
    public suspend fun inputs(vararg argument: suspend FunctionInputArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FunctionInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fsquwhyajcmgdhkf")
    public suspend fun inputs(argument: suspend FunctionInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FunctionInputArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param values
     */
    @JvmName("biyngcleoowschrl")
    public suspend fun inputs(vararg values: FunctionInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value Describes the output of a function.
     */
    @JvmName("kcbbquwecskrboeh")
    public suspend fun output(`value`: FunctionOutputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.output = mapped
    }

    /**
     * @param argument Describes the output of a function.
     */
    @JvmName("aqlvuyfqmhmvamgb")
    public suspend fun output(argument: suspend FunctionOutputArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionOutputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.output = mapped
    }

    /**
     * @param value Indicates the type of function.
     * Expected value is 'Scalar'.
     */
    @JvmName("xxhsqqkekltbnomy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScalarFunctionPropertiesArgs = ScalarFunctionPropertiesArgs(
        binding = binding,
        inputs = inputs,
        output = output,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
