@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.ServiceBusTopicOutputDataSourceArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.AuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Service Bus Topic output data source.
 * @property authenticationMode Authentication Mode.
 * @property propertyColumns A string array of the names of output columns to be attached to Service Bus messages as custom properties.
 * @property serviceBusNamespace The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyKey The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyName The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property systemPropertyColumns The system properties associated with the Service Bus Topic Output. The following system properties are supported: ReplyToSessionId, ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
 * @property topicName The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.ServiceBus/Topic'.
 */
public data class ServiceBusTopicOutputDataSourceArgs(
    public val authenticationMode: Output<Either<String, AuthenticationMode>>? = null,
    public val propertyColumns: Output<List<String>>? = null,
    public val serviceBusNamespace: Output<String>? = null,
    public val sharedAccessPolicyKey: Output<String>? = null,
    public val sharedAccessPolicyName: Output<String>? = null,
    public val systemPropertyColumns: Output<Map<String, String>>? = null,
    public val topicName: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.ServiceBusTopicOutputDataSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.streamanalytics.inputs.ServiceBusTopicOutputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.ServiceBusTopicOutputDataSourceArgs.builder()
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .propertyColumns(propertyColumns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceBusNamespace(serviceBusNamespace?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyKey(sharedAccessPolicyKey?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyName(sharedAccessPolicyName?.applyValue({ args0 -> args0 }))
            .systemPropertyColumns(
                systemPropertyColumns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .topicName(topicName?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceBusTopicOutputDataSourceArgs].
 */
@PulumiTagMarker
public class ServiceBusTopicOutputDataSourceArgsBuilder internal constructor() {
    private var authenticationMode: Output<Either<String, AuthenticationMode>>? = null

    private var propertyColumns: Output<List<String>>? = null

    private var serviceBusNamespace: Output<String>? = null

    private var sharedAccessPolicyKey: Output<String>? = null

    private var sharedAccessPolicyName: Output<String>? = null

    private var systemPropertyColumns: Output<Map<String, String>>? = null

    private var topicName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Authentication Mode.
     */
    @JvmName("vrafyohatawtyvob")
    public suspend fun authenticationMode(`value`: Output<Either<String, AuthenticationMode>>) {
        this.authenticationMode = value
    }

    /**
     * @param value A string array of the names of output columns to be attached to Service Bus messages as custom properties.
     */
    @JvmName("nvuijwrdpyupbjep")
    public suspend fun propertyColumns(`value`: Output<List<String>>) {
        this.propertyColumns = value
    }

    @JvmName("mseamlshtalnamet")
    public suspend fun propertyColumns(vararg values: Output<String>) {
        this.propertyColumns = Output.all(values.asList())
    }

    /**
     * @param values A string array of the names of output columns to be attached to Service Bus messages as custom properties.
     */
    @JvmName("jgugkfekxcmruefb")
    public suspend fun propertyColumns(values: List<Output<String>>) {
        this.propertyColumns = Output.all(values)
    }

    /**
     * @param value The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("wusarykknanykhel")
    public suspend fun serviceBusNamespace(`value`: Output<String>) {
        this.serviceBusNamespace = value
    }

    /**
     * @param value The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ehptorkkyysvhmfj")
    public suspend fun sharedAccessPolicyKey(`value`: Output<String>) {
        this.sharedAccessPolicyKey = value
    }

    /**
     * @param value The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("kfufybguwiilnjod")
    public suspend fun sharedAccessPolicyName(`value`: Output<String>) {
        this.sharedAccessPolicyName = value
    }

    /**
     * @param value The system properties associated with the Service Bus Topic Output. The following system properties are supported: ReplyToSessionId, ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
     */
    @JvmName("pdnnhcueyfijrwhk")
    public suspend fun systemPropertyColumns(`value`: Output<Map<String, String>>) {
        this.systemPropertyColumns = value
    }

    /**
     * @param value The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("wriiwtxtjknnpkms")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.ServiceBus/Topic'.
     */
    @JvmName("pqmpkrtrfuyqdjuu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("cbgadokmaatxsqbg")
    public suspend fun authenticationMode(`value`: Either<String, AuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("fukjlastbcyohhdr")
    public fun authenticationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Authentication Mode.
     */
    @JvmName("rioxmcxpcuygdqqs")
    public fun authenticationMode(`value`: AuthenticationMode) {
        val toBeMapped = Either.ofRight<String, AuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value A string array of the names of output columns to be attached to Service Bus messages as custom properties.
     */
    @JvmName("aewmghiyvxmojosg")
    public suspend fun propertyColumns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyColumns = mapped
    }

    /**
     * @param values A string array of the names of output columns to be attached to Service Bus messages as custom properties.
     */
    @JvmName("ymbyexccgxabkyhs")
    public suspend fun propertyColumns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyColumns = mapped
    }

    /**
     * @param value The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("oovqedlbcjyuiryd")
    public suspend fun serviceBusNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusNamespace = mapped
    }

    /**
     * @param value The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("otiltcntgnyqijab")
    public suspend fun sharedAccessPolicyKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyKey = mapped
    }

    /**
     * @param value The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("hgnmixvgdfxjwahi")
    public suspend fun sharedAccessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyName = mapped
    }

    /**
     * @param value The system properties associated with the Service Bus Topic Output. The following system properties are supported: ReplyToSessionId, ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
     */
    @JvmName("uvtcaagkoktifyir")
    public suspend fun systemPropertyColumns(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemPropertyColumns = mapped
    }

    /**
     * @param values The system properties associated with the Service Bus Topic Output. The following system properties are supported: ReplyToSessionId, ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
     */
    @JvmName("abmcoefyivecpmep")
    public fun systemPropertyColumns(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemPropertyColumns = mapped
    }

    /**
     * @param value The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("owumopwdkrfjqbuo")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    /**
     * @param value Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.ServiceBus/Topic'.
     */
    @JvmName("tptkbvnbrxahhgvy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceBusTopicOutputDataSourceArgs = ServiceBusTopicOutputDataSourceArgs(
        authenticationMode = authenticationMode,
        propertyColumns = propertyColumns,
        serviceBusNamespace = serviceBusNamespace,
        sharedAccessPolicyKey = sharedAccessPolicyKey,
        sharedAccessPolicyName = sharedAccessPolicyName,
        systemPropertyColumns = systemPropertyColumns,
        topicName = topicName,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
