@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes an Event Hub output data source.
 * @property authenticationMode Authentication Mode.
 * @property eventHubName The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
 * @property partitionKey The key/column that is used to determine to which partition to send event data.
 * @property propertyColumns The properties associated with this Event Hub output.
 * @property serviceBusNamespace The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyKey The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyName The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.ServiceBus/EventHub'.
 */
public data class EventHubOutputDataSourceResponse(
    public val authenticationMode: String? = null,
    public val eventHubName: String? = null,
    public val partitionKey: String? = null,
    public val propertyColumns: List<String>? = null,
    public val serviceBusNamespace: String? = null,
    public val sharedAccessPolicyKey: String? = null,
    public val sharedAccessPolicyName: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.EventHubOutputDataSourceResponse):
            EventHubOutputDataSourceResponse = EventHubOutputDataSourceResponse(
            authenticationMode = javaType.authenticationMode().map({ args0 -> args0 }).orElse(null),
            eventHubName = javaType.eventHubName().map({ args0 -> args0 }).orElse(null),
            partitionKey = javaType.partitionKey().map({ args0 -> args0 }).orElse(null),
            propertyColumns = javaType.propertyColumns().map({ args0 -> args0 }),
            serviceBusNamespace = javaType.serviceBusNamespace().map({ args0 -> args0 }).orElse(null),
            sharedAccessPolicyKey = javaType.sharedAccessPolicyKey().map({ args0 -> args0 }).orElse(null),
            sharedAccessPolicyName = javaType.sharedAccessPolicyName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
