@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Describes one input parameter of a function.
 * @property dataType The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
 * @property isConfigurationParameter A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false.
 */
public data class FunctionInputResponse(
    public val dataType: String? = null,
    public val isConfigurationParameter: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.FunctionInputResponse):
            FunctionInputResponse = FunctionInputResponse(
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
            isConfigurationParameter = javaType.isConfigurationParameter().map({ args0 -> args0 }).orElse(null),
        )
    }
}
