@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The binding to a JavaScript function.
 * @property script The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
 * @property type Indicates the function binding type.
 * Expected value is 'Microsoft.StreamAnalytics/JavascriptUdf'.
 */
public data class JavaScriptFunctionBindingResponse(
    public val script: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.JavaScriptFunctionBindingResponse):
            JavaScriptFunctionBindingResponse = JavaScriptFunctionBindingResponse(
            script = javaType.script().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
