@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a Power BI output data source.
 * @property authenticationMode Authentication Mode.
 * @property dataset The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
 * @property groupId The ID of the Power BI group.
 * @property groupName The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
 * @property refreshToken A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
 * @property table The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
 * @property tokenUserDisplayName The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
 * @property tokenUserPrincipalName The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'PowerBI'.
 */
public data class PowerBIOutputDataSourceResponse(
    public val authenticationMode: String? = null,
    public val dataset: String? = null,
    public val groupId: String? = null,
    public val groupName: String? = null,
    public val refreshToken: String? = null,
    public val table: String? = null,
    public val tokenUserDisplayName: String? = null,
    public val tokenUserPrincipalName: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.PowerBIOutputDataSourceResponse):
            PowerBIOutputDataSourceResponse = PowerBIOutputDataSourceResponse(
            authenticationMode = javaType.authenticationMode().map({ args0 -> args0 }).orElse(null),
            dataset = javaType.dataset().map({ args0 -> args0 }).orElse(null),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            groupName = javaType.groupName().map({ args0 -> args0 }).orElse(null),
            refreshToken = javaType.refreshToken().map({ args0 -> args0 }).orElse(null),
            table = javaType.table().map({ args0 -> args0 }).orElse(null),
            tokenUserDisplayName = javaType.tokenUserDisplayName().map({ args0 -> args0 }).orElse(null),
            tokenUserPrincipalName = javaType.tokenUserPrincipalName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
