@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A grouping of information about the connection to the remote resource.
 * @property groupIds The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
 * @property privateLinkServiceConnectionState A collection of read-only information about the state of the connection to the private remote resource.
 * @property privateLinkServiceId The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
 * @property requestMessage A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
 */
public data class PrivateLinkServiceConnectionResponse(
    public val groupIds: List<String>? = null,
    public val privateLinkServiceConnectionState: PrivateLinkConnectionStateResponse? = null,
    public val privateLinkServiceId: String? = null,
    public val requestMessage: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.PrivateLinkServiceConnectionResponse):
            PrivateLinkServiceConnectionResponse = PrivateLinkServiceConnectionResponse(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.PrivateLinkConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceId = javaType.privateLinkServiceId().map({ args0 -> args0 }).orElse(null),
            requestMessage = javaType.requestMessage(),
        )
    }
}
