@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.KustoPoolArgs.builder
import com.pulumi.azurenative.synapse.kotlin.inputs.AzureSkuArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.AzureSkuArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.OptimizedAutoscaleArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.OptimizedAutoscaleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Class representing a Kusto kusto pool.
 * Azure REST API version: 2021-06-01-preview.
 * ## Example Usage
 * ### kustoPoolsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoPool = new AzureNative.Synapse.KustoPool("kustoPool", new()
 *     {
 *         EnablePurge = true,
 *         EnableStreamingIngest = true,
 *         KustoPoolName = "kustoclusterrptest4",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *         Sku = new AzureNative.Synapse.Inputs.AzureSkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "Storage optimized",
 *             Size = "Medium",
 *         },
 *         WorkspaceName = "synapseWorkspaceName",
 *         WorkspaceUID = "11111111-2222-3333-444444444444",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewKustoPool(ctx, "kustoPool", &synapse.KustoPoolArgs{
 * 			EnablePurge:           pulumi.Bool(true),
 * 			EnableStreamingIngest: pulumi.Bool(true),
 * 			KustoPoolName:         pulumi.String("kustoclusterrptest4"),
 * 			Location:              pulumi.String("westus"),
 * 			ResourceGroupName:     pulumi.String("kustorptest"),
 * 			Sku: &synapse.AzureSkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("Storage optimized"),
 * 				Size:     pulumi.String("Medium"),
 * 			},
 * 			WorkspaceName: pulumi.String("synapseWorkspaceName"),
 * 			WorkspaceUID:  pulumi.String("11111111-2222-3333-444444444444"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.KustoPool;
 * import com.pulumi.azurenative.synapse.KustoPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoPool = new KustoPool("kustoPool", KustoPoolArgs.builder()
 *             .enablePurge(true)
 *             .enableStreamingIngest(true)
 *             .kustoPoolName("kustoclusterrptest4")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "Storage optimized"),
 *                 Map.entry("size", "Medium")
 *             ))
 *             .workspaceName("synapseWorkspaceName")
 *             .workspaceUID("11111111-2222-3333-444444444444")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:KustoPool KustoClusterRPTest4 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}
 * ```
 * @property enablePurge A boolean value that indicates if the purge operations are enabled.
 * @property enableStreamingIngest A boolean value that indicates if the streaming ingest is enabled.
 * @property kustoPoolName The name of the Kusto pool.
 * @property location The geo-location where the resource lives
 * @property optimizedAutoscale Optimized auto scale definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU of the kusto pool.
 * @property tags Resource tags.
 * @property workspaceName The name of the workspace.
 * @property workspaceUID The workspace unique identifier.
 */
public data class KustoPoolArgs(
    public val enablePurge: Output<Boolean>? = null,
    public val enableStreamingIngest: Output<Boolean>? = null,
    public val kustoPoolName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val optimizedAutoscale: Output<OptimizedAutoscaleArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<AzureSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
    public val workspaceUID: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.KustoPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.KustoPoolArgs =
        com.pulumi.azurenative.synapse.KustoPoolArgs.builder()
            .enablePurge(enablePurge?.applyValue({ args0 -> args0 }))
            .enableStreamingIngest(enableStreamingIngest?.applyValue({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .optimizedAutoscale(
                optimizedAutoscale?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 }))
            .workspaceUID(workspaceUID?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KustoPoolArgs].
 */
@PulumiTagMarker
public class KustoPoolArgsBuilder internal constructor() {
    private var enablePurge: Output<Boolean>? = null

    private var enableStreamingIngest: Output<Boolean>? = null

    private var kustoPoolName: Output<String>? = null

    private var location: Output<String>? = null

    private var optimizedAutoscale: Output<OptimizedAutoscaleArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<AzureSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    private var workspaceUID: Output<String>? = null

    /**
     * @param value A boolean value that indicates if the purge operations are enabled.
     */
    @JvmName("lgyiisjiujafwttg")
    public suspend fun enablePurge(`value`: Output<Boolean>) {
        this.enablePurge = value
    }

    /**
     * @param value A boolean value that indicates if the streaming ingest is enabled.
     */
    @JvmName("ephnjqsvbbmnlxcc")
    public suspend fun enableStreamingIngest(`value`: Output<Boolean>) {
        this.enableStreamingIngest = value
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("ktsfqhtrsrmuldha")
    public suspend fun kustoPoolName(`value`: Output<String>) {
        this.kustoPoolName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mmjwivjstswsxbkj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Optimized auto scale definition.
     */
    @JvmName("kifromyjfqdgbsng")
    public suspend fun optimizedAutoscale(`value`: Output<OptimizedAutoscaleArgs>) {
        this.optimizedAutoscale = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kirkfcwmxknmmymd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU of the kusto pool.
     */
    @JvmName("qlppebkwluguxnqp")
    public suspend fun sku(`value`: Output<AzureSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pcqgtwifjaibllar")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("nakwkdovebpyrmsn")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The workspace unique identifier.
     */
    @JvmName("naohdhnxwrlqcyqo")
    public suspend fun workspaceUID(`value`: Output<String>) {
        this.workspaceUID = value
    }

    /**
     * @param value A boolean value that indicates if the purge operations are enabled.
     */
    @JvmName("ylnpwankmoryysbq")
    public suspend fun enablePurge(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePurge = mapped
    }

    /**
     * @param value A boolean value that indicates if the streaming ingest is enabled.
     */
    @JvmName("nvqkybtsplbvmdqi")
    public suspend fun enableStreamingIngest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStreamingIngest = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("xydmhmhbdcnkqnsu")
    public suspend fun kustoPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoPoolName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rmkautntvskawjww")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Optimized auto scale definition.
     */
    @JvmName("kvhjxyjeetfxchci")
    public suspend fun optimizedAutoscale(`value`: OptimizedAutoscaleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizedAutoscale = mapped
    }

    /**
     * @param argument Optimized auto scale definition.
     */
    @JvmName("pmpemhucotyevtjk")
    public suspend
    fun optimizedAutoscale(argument: suspend OptimizedAutoscaleArgsBuilder.() -> Unit) {
        val toBeMapped = OptimizedAutoscaleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.optimizedAutoscale = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dpvdnauemmipkdwb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU of the kusto pool.
     */
    @JvmName("rngjqknhmfyexmqr")
    public suspend fun sku(`value`: AzureSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the kusto pool.
     */
    @JvmName("ugojrupnmtwhnjyl")
    public suspend fun sku(argument: suspend AzureSkuArgsBuilder.() -> Unit) {
        val toBeMapped = AzureSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rbojlgjlxvbiyrfi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tysjvvuvptsaxylq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("gbqurwdktanwviqj")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    /**
     * @param value The workspace unique identifier.
     */
    @JvmName("trnnrggueuqymsoq")
    public suspend fun workspaceUID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceUID = mapped
    }

    internal fun build(): KustoPoolArgs = KustoPoolArgs(
        enablePurge = enablePurge,
        enableStreamingIngest = enableStreamingIngest,
        kustoPoolName = kustoPoolName,
        location = location,
        optimizedAutoscale = optimizedAutoscale,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        workspaceName = workspaceName,
        workspaceUID = workspaceUID,
    )
}
