@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentArgs.builder
import com.pulumi.azurenative.synapse.kotlin.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.VulnerabilityAssessmentRecurringScansPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A Sql pool vulnerability assessment.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create a database's vulnerability assessment with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolVulnerabilityAssessment = new AzureNative.Synapse.SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", new()
 *     {
 *         RecurringScans = new AzureNative.Synapse.Inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs
 *         {
 *             EmailSubscriptionAdmins = true,
 *             Emails = new[]
 *             {
 *                 "email1@mail.com",
 *                 "email2@mail.com",
 *             },
 *             IsEnabled = true,
 *         },
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         SqlPoolName = "testdb",
 *         StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "vulnerabilityaseessmenttest-6440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolVulnerabilityAssessment(ctx, "sqlPoolVulnerabilityAssessment", &synapse.SqlPoolVulnerabilityAssessmentArgs{
 * 			RecurringScans: &synapse.VulnerabilityAssessmentRecurringScansPropertiesArgs{
 * 				EmailSubscriptionAdmins: pulumi.Bool(true),
 * 				Emails: pulumi.StringArray{
 * 					pulumi.String("email1@mail.com"),
 * 					pulumi.String("email2@mail.com"),
 * 				},
 * 				IsEnabled: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			SqlPoolName:                 pulumi.String("testdb"),
 * 			StorageAccountAccessKey:     pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolVulnerabilityAssessment = new SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", SqlPoolVulnerabilityAssessmentArgs.builder()
 *             .recurringScans(Map.ofEntries(
 *                 Map.entry("emailSubscriptionAdmins", true),
 *                 Map.entry("emails",
 *                     "email1@mail.com",
 *                     "email2@mail.com"),
 *                 Map.entry("isEnabled", true)
 *             ))
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .sqlPoolName("testdb")
 *             .storageAccountAccessKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("vulnerabilityaseessmenttest-6440")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a database's vulnerability assessment with minimal parameters, when storageAccountAccessKey is specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolVulnerabilityAssessment = new AzureNative.Synapse.SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         SqlPoolName = "testdb",
 *         StorageAccountAccessKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "vulnerabilityaseessmenttest-6440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolVulnerabilityAssessment(ctx, "sqlPoolVulnerabilityAssessment", &synapse.SqlPoolVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			SqlPoolName:                 pulumi.String("testdb"),
 * 			StorageAccountAccessKey:     pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolVulnerabilityAssessment = new SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", SqlPoolVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .sqlPoolName("testdb")
 *             .storageAccountAccessKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("vulnerabilityaseessmenttest-6440")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a database's vulnerability assessment with minimal parameters, when storageContainerSasKey is specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolVulnerabilityAssessment = new AzureNative.Synapse.SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", new()
 *     {
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         SqlPoolName = "testdb",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *         WorkspaceName = "vulnerabilityaseessmenttest-6440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolVulnerabilityAssessment(ctx, "sqlPoolVulnerabilityAssessment", &synapse.SqlPoolVulnerabilityAssessmentArgs{
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			SqlPoolName:                 pulumi.String("testdb"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 			WorkspaceName:               pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessment;
 * import com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolVulnerabilityAssessment = new SqlPoolVulnerabilityAssessment("sqlPoolVulnerabilityAssessment", SqlPoolVulnerabilityAssessmentArgs.builder()
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .sqlPoolName("testdb")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .workspaceName("vulnerabilityaseessmenttest-6440")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolVulnerabilityAssessment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}
 * ```
 * @property recurringScans The recurring scans settings
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sqlPoolName SQL pool name
 * @property storageAccountAccessKey Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
 * @property storageContainerPath A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
 * @property storageContainerSasKey A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 * @property workspaceName The name of the workspace.
 */
public data class SqlPoolVulnerabilityAssessmentArgs(
    public val recurringScans: Output<VulnerabilityAssessmentRecurringScansPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlPoolName: Output<String>? = null,
    public val storageAccountAccessKey: Output<String>? = null,
    public val storageContainerPath: Output<String>? = null,
    public val storageContainerSasKey: Output<String>? = null,
    public val vulnerabilityAssessmentName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentArgs =
        com.pulumi.azurenative.synapse.SqlPoolVulnerabilityAssessmentArgs.builder()
            .recurringScans(recurringScans?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName?.applyValue({ args0 -> args0 }))
            .storageAccountAccessKey(storageAccountAccessKey?.applyValue({ args0 -> args0 }))
            .storageContainerPath(storageContainerPath?.applyValue({ args0 -> args0 }))
            .storageContainerSasKey(storageContainerSasKey?.applyValue({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlPoolVulnerabilityAssessmentArgs].
 */
@PulumiTagMarker
public class SqlPoolVulnerabilityAssessmentArgsBuilder internal constructor() {
    private var recurringScans: Output<VulnerabilityAssessmentRecurringScansPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlPoolName: Output<String>? = null

    private var storageAccountAccessKey: Output<String>? = null

    private var storageContainerPath: Output<String>? = null

    private var storageContainerSasKey: Output<String>? = null

    private var vulnerabilityAssessmentName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The recurring scans settings
     */
    @JvmName("wmvkdiiukpmwyoqv")
    public suspend
    fun recurringScans(`value`: Output<VulnerabilityAssessmentRecurringScansPropertiesArgs>) {
        this.recurringScans = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("djmmkiqbfkmcyoku")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("oaqlqishwrsyqoxw")
    public suspend fun sqlPoolName(`value`: Output<String>) {
        this.sqlPoolName = value
    }

    /**
     * @param value Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     */
    @JvmName("wagavpnrhgopirey")
    public suspend fun storageAccountAccessKey(`value`: Output<String>) {
        this.storageAccountAccessKey = value
    }

    /**
     * @param value A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
     */
    @JvmName("nscbejvsuetfuldd")
    public suspend fun storageContainerPath(`value`: Output<String>) {
        this.storageContainerPath = value
    }

    /**
     * @param value A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
     */
    @JvmName("yjcfskpgkmkfkqej")
    public suspend fun storageContainerSasKey(`value`: Output<String>) {
        this.storageContainerSasKey = value
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("wiyqmnrcidqxsqsa")
    public suspend fun vulnerabilityAssessmentName(`value`: Output<String>) {
        this.vulnerabilityAssessmentName = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("hrgbcspvmbjaeimo")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The recurring scans settings
     */
    @JvmName("tpmeltlqypocoyrk")
    public suspend fun recurringScans(`value`: VulnerabilityAssessmentRecurringScansPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurringScans = mapped
    }

    /**
     * @param argument The recurring scans settings
     */
    @JvmName("ywldsferpcspnfba")
    public suspend
    fun recurringScans(argument: suspend VulnerabilityAssessmentRecurringScansPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VulnerabilityAssessmentRecurringScansPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.recurringScans = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("elmrbdkymegelpqq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("qsjnpqdairkphiey")
    public suspend fun sqlPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlPoolName = mapped
    }

    /**
     * @param value Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     */
    @JvmName("rjaktaaaqoimfgmk")
    public suspend fun storageAccountAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountAccessKey = mapped
    }

    /**
     * @param value A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
     */
    @JvmName("nbeqxafpxiliwara")
    public suspend fun storageContainerPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerPath = mapped
    }

    /**
     * @param value A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
     */
    @JvmName("hunqtbajydrdgjok")
    public suspend fun storageContainerSasKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainerSasKey = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("ermhwrqrgcwxglib")
    public suspend fun vulnerabilityAssessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulnerabilityAssessmentName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("lpckqvblhytcfbqg")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): SqlPoolVulnerabilityAssessmentArgs = SqlPoolVulnerabilityAssessmentArgs(
        recurringScans = recurringScans,
        resourceGroupName = resourceGroupName,
        sqlPoolName = sqlPoolName,
        storageAccountAccessKey = storageAccountAccessKey,
        storageContainerPath = storageContainerPath,
        storageContainerSasKey = storageContainerSasKey,
        vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        workspaceName = workspaceName,
    )
}
