@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.WorkspaceArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.WorkspacePublicNetworkAccess
import com.pulumi.azurenative.synapse.kotlin.inputs.CspWorkspaceAdminPropertiesArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.CspWorkspaceAdminPropertiesArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.DataLakeStorageAccountDetailsArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.DataLakeStorageAccountDetailsArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.EncryptionDetailsArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.EncryptionDetailsArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.ManagedIdentityArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.ManagedIdentityArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.ManagedVirtualNetworkSettingsArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.ManagedVirtualNetworkSettingsArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.PrivateEndpointConnectionArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.PrivateEndpointConnectionArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.PurviewConfigurationArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.PurviewConfigurationArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.VirtualNetworkProfileArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.VirtualNetworkProfileArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.WorkspaceRepositoryConfigurationArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.WorkspaceRepositoryConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A workspace
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-05-01, 2021-06-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:Workspace workspace1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}
 * ```
 * @property azureADOnlyAuthentication Enable or Disable AzureADOnlyAuthentication on All Workspace subresource
 * @property cspWorkspaceAdminProperties Initial workspace AAD admin properties for a CSP subscription
 * @property defaultDataLakeStorage Workspace default data lake storage account details
 * @property encryption The encryption details of the workspace
 * @property identity Identity of the workspace
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupName Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId. The resource group name must be no longer than 90 characters long, and must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with '.'
 * @property managedVirtualNetwork Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of the user.
 * @property managedVirtualNetworkSettings Managed Virtual Network Settings
 * @property privateEndpointConnections Private endpoint connections to the workspace
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property publicNetworkAccess Enable or Disable public network access to workspace
 * @property purviewConfiguration Purview Configuration
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sqlAdministratorLogin Login for workspace SQL active directory administrator
 * @property sqlAdministratorLoginPassword SQL administrator login password
 * @property tags Resource tags.
 * @property trustedServiceBypassEnabled Is trustedServiceBypassEnabled for the workspace
 * @property virtualNetworkProfile Virtual Network profile
 * @property workspaceName The name of the workspace.
 * @property workspaceRepositoryConfiguration Git integration settings
 */
public data class WorkspaceArgs(
    public val azureADOnlyAuthentication: Output<Boolean>? = null,
    public val cspWorkspaceAdminProperties: Output<CspWorkspaceAdminPropertiesArgs>? = null,
    public val defaultDataLakeStorage: Output<DataLakeStorageAccountDetailsArgs>? = null,
    public val encryption: Output<EncryptionDetailsArgs>? = null,
    public val identity: Output<ManagedIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val managedResourceGroupName: Output<String>? = null,
    public val managedVirtualNetwork: Output<String>? = null,
    public val managedVirtualNetworkSettings: Output<ManagedVirtualNetworkSettingsArgs>? = null,
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null,
    public val publicNetworkAccess: Output<Either<String, WorkspacePublicNetworkAccess>>? = null,
    public val purviewConfiguration: Output<PurviewConfigurationArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlAdministratorLogin: Output<String>? = null,
    public val sqlAdministratorLoginPassword: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trustedServiceBypassEnabled: Output<Boolean>? = null,
    public val virtualNetworkProfile: Output<VirtualNetworkProfileArgs>? = null,
    public val workspaceName: Output<String>? = null,
    public val workspaceRepositoryConfiguration: Output<WorkspaceRepositoryConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.WorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.WorkspaceArgs =
        com.pulumi.azurenative.synapse.WorkspaceArgs.builder()
            .azureADOnlyAuthentication(azureADOnlyAuthentication?.applyValue({ args0 -> args0 }))
            .cspWorkspaceAdminProperties(
                cspWorkspaceAdminProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultDataLakeStorage(
                defaultDataLakeStorage?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedResourceGroupName(managedResourceGroupName?.applyValue({ args0 -> args0 }))
            .managedVirtualNetwork(managedVirtualNetwork?.applyValue({ args0 -> args0 }))
            .managedVirtualNetworkSettings(
                managedVirtualNetworkSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .purviewConfiguration(
                purviewConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlAdministratorLogin(sqlAdministratorLogin?.applyValue({ args0 -> args0 }))
            .sqlAdministratorLoginPassword(sqlAdministratorLoginPassword?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trustedServiceBypassEnabled(trustedServiceBypassEnabled?.applyValue({ args0 -> args0 }))
            .virtualNetworkProfile(
                virtualNetworkProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 }))
            .workspaceRepositoryConfiguration(
                workspaceRepositoryConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var azureADOnlyAuthentication: Output<Boolean>? = null

    private var cspWorkspaceAdminProperties: Output<CspWorkspaceAdminPropertiesArgs>? = null

    private var defaultDataLakeStorage: Output<DataLakeStorageAccountDetailsArgs>? = null

    private var encryption: Output<EncryptionDetailsArgs>? = null

    private var identity: Output<ManagedIdentityArgs>? = null

    private var location: Output<String>? = null

    private var managedResourceGroupName: Output<String>? = null

    private var managedVirtualNetwork: Output<String>? = null

    private var managedVirtualNetworkSettings: Output<ManagedVirtualNetworkSettingsArgs>? = null

    private var privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null

    private var publicNetworkAccess: Output<Either<String, WorkspacePublicNetworkAccess>>? = null

    private var purviewConfiguration: Output<PurviewConfigurationArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlAdministratorLogin: Output<String>? = null

    private var sqlAdministratorLoginPassword: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trustedServiceBypassEnabled: Output<Boolean>? = null

    private var virtualNetworkProfile: Output<VirtualNetworkProfileArgs>? = null

    private var workspaceName: Output<String>? = null

    private var workspaceRepositoryConfiguration: Output<WorkspaceRepositoryConfigurationArgs>? = null

    /**
     * @param value Enable or Disable AzureADOnlyAuthentication on All Workspace subresource
     */
    @JvmName("chsqbfbtcshcgdcm")
    public suspend fun azureADOnlyAuthentication(`value`: Output<Boolean>) {
        this.azureADOnlyAuthentication = value
    }

    /**
     * @param value Initial workspace AAD admin properties for a CSP subscription
     */
    @JvmName("qjbppfobbxsdnnmw")
    public suspend fun cspWorkspaceAdminProperties(`value`: Output<CspWorkspaceAdminPropertiesArgs>) {
        this.cspWorkspaceAdminProperties = value
    }

    /**
     * @param value Workspace default data lake storage account details
     */
    @JvmName("qvjofvgwcdbqkael")
    public suspend fun defaultDataLakeStorage(`value`: Output<DataLakeStorageAccountDetailsArgs>) {
        this.defaultDataLakeStorage = value
    }

    /**
     * @param value The encryption details of the workspace
     */
    @JvmName("yntgigctxaefttke")
    public suspend fun encryption(`value`: Output<EncryptionDetailsArgs>) {
        this.encryption = value
    }

    /**
     * @param value Identity of the workspace
     */
    @JvmName("umhpeqnwuavsmdah")
    public suspend fun identity(`value`: Output<ManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("locyrtcepciesjhp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId. The resource group name must be no longer than 90 characters long, and must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with '.'
     */
    @JvmName("tdypicvssfbdvvxa")
    public suspend fun managedResourceGroupName(`value`: Output<String>) {
        this.managedResourceGroupName = value
    }

    /**
     * @param value Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of the user.
     */
    @JvmName("amictlgeixnipbyi")
    public suspend fun managedVirtualNetwork(`value`: Output<String>) {
        this.managedVirtualNetwork = value
    }

    /**
     * @param value Managed Virtual Network Settings
     */
    @JvmName("xdoeuijkgieggojy")
    public suspend
    fun managedVirtualNetworkSettings(`value`: Output<ManagedVirtualNetworkSettingsArgs>) {
        this.managedVirtualNetworkSettings = value
    }

    /**
     * @param value Private endpoint connections to the workspace
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("yogdnqucromahhun")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("onormkqwtcuhlhoa")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<PrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values Private endpoint connections to the workspace
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("txeujxnxnhjybkip")
    public suspend
    fun privateEndpointConnections(values: List<Output<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value Enable or Disable public network access to workspace
     */
    @JvmName("hwtmcfywwwhgdspx")
    public suspend
    fun publicNetworkAccess(`value`: Output<Either<String, WorkspacePublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Purview Configuration
     */
    @JvmName("lisfwyabxknqdhbx")
    public suspend fun purviewConfiguration(`value`: Output<PurviewConfigurationArgs>) {
        this.purviewConfiguration = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wksfufoawjsqrkmj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Login for workspace SQL active directory administrator
     */
    @JvmName("qxstrjjpjskhbqfg")
    public suspend fun sqlAdministratorLogin(`value`: Output<String>) {
        this.sqlAdministratorLogin = value
    }

    /**
     * @param value SQL administrator login password
     */
    @JvmName("uwglhhitucfwutuc")
    public suspend fun sqlAdministratorLoginPassword(`value`: Output<String>) {
        this.sqlAdministratorLoginPassword = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bdavdkmuugbajnml")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Is trustedServiceBypassEnabled for the workspace
     */
    @JvmName("aebllawlyqadnmyr")
    public suspend fun trustedServiceBypassEnabled(`value`: Output<Boolean>) {
        this.trustedServiceBypassEnabled = value
    }

    /**
     * @param value Virtual Network profile
     */
    @JvmName("natlsmhmlcqjeyhc")
    public suspend fun virtualNetworkProfile(`value`: Output<VirtualNetworkProfileArgs>) {
        this.virtualNetworkProfile = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("skxjwsvfxhflvych")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Git integration settings
     */
    @JvmName("nphmmfgajlwqvwoy")
    public suspend
    fun workspaceRepositoryConfiguration(`value`: Output<WorkspaceRepositoryConfigurationArgs>) {
        this.workspaceRepositoryConfiguration = value
    }

    /**
     * @param value Enable or Disable AzureADOnlyAuthentication on All Workspace subresource
     */
    @JvmName("yevmipopapsbncdo")
    public suspend fun azureADOnlyAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureADOnlyAuthentication = mapped
    }

    /**
     * @param value Initial workspace AAD admin properties for a CSP subscription
     */
    @JvmName("npaiyrriwduwcxja")
    public suspend fun cspWorkspaceAdminProperties(`value`: CspWorkspaceAdminPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cspWorkspaceAdminProperties = mapped
    }

    /**
     * @param argument Initial workspace AAD admin properties for a CSP subscription
     */
    @JvmName("ktjehfscoepaikup")
    public suspend
    fun cspWorkspaceAdminProperties(argument: suspend CspWorkspaceAdminPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CspWorkspaceAdminPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cspWorkspaceAdminProperties = mapped
    }

    /**
     * @param value Workspace default data lake storage account details
     */
    @JvmName("uvfnepcsdofrubys")
    public suspend fun defaultDataLakeStorage(`value`: DataLakeStorageAccountDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDataLakeStorage = mapped
    }

    /**
     * @param argument Workspace default data lake storage account details
     */
    @JvmName("louyitiqxkptreaa")
    public suspend
    fun defaultDataLakeStorage(argument: suspend DataLakeStorageAccountDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeStorageAccountDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultDataLakeStorage = mapped
    }

    /**
     * @param value The encryption details of the workspace
     */
    @JvmName("msgbteyihsliqdfk")
    public suspend fun encryption(`value`: EncryptionDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument The encryption details of the workspace
     */
    @JvmName("gurtbrebnfmixith")
    public suspend fun encryption(argument: suspend EncryptionDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Identity of the workspace
     */
    @JvmName("insiwvrbrerojyub")
    public suspend fun identity(`value`: ManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity of the workspace
     */
    @JvmName("cjepxhgjxerqhjiv")
    public suspend fun identity(argument: suspend ManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fiukejtartdtjhcr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId. The resource group name must be no longer than 90 characters long, and must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with '.'
     */
    @JvmName("fdmwjduondsnmywl")
    public suspend fun managedResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupName = mapped
    }

    /**
     * @param value Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of the user.
     */
    @JvmName("nyjuqoywurxyeiwh")
    public suspend fun managedVirtualNetwork(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedVirtualNetwork = mapped
    }

    /**
     * @param value Managed Virtual Network Settings
     */
    @JvmName("kjffieyytxmeyxkk")
    public suspend fun managedVirtualNetworkSettings(`value`: ManagedVirtualNetworkSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedVirtualNetworkSettings = mapped
    }

    /**
     * @param argument Managed Virtual Network Settings
     */
    @JvmName("isuxoiefvdfmxtcp")
    public suspend
    fun managedVirtualNetworkSettings(argument: suspend ManagedVirtualNetworkSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedVirtualNetworkSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedVirtualNetworkSettings = mapped
    }

    /**
     * @param value Private endpoint connections to the workspace
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pccusoclvlscvtdw")
    public suspend fun privateEndpointConnections(`value`: List<PrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections to the workspace
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xnffftanujlduxur")
    public suspend
    fun privateEndpointConnections(argument: List<suspend PrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections to the workspace
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("qipiwvafwepyighw")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections to the workspace
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("iynuhunxxgdaipax")
    public suspend
    fun privateEndpointConnections(argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values Private endpoint connections to the workspace
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("yxgykixkvivjeerv")
    public suspend fun privateEndpointConnections(vararg values: PrivateEndpointConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value Enable or Disable public network access to workspace
     */
    @JvmName("ahjabwgxpsxsxvgd")
    public suspend fun publicNetworkAccess(`value`: Either<String, WorkspacePublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Enable or Disable public network access to workspace
     */
    @JvmName("rpqmitrfwgmkmfqe")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkspacePublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Enable or Disable public network access to workspace
     */
    @JvmName("efjkhukhgsctofyv")
    public fun publicNetworkAccess(`value`: WorkspacePublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, WorkspacePublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Purview Configuration
     */
    @JvmName("mbpkhimjitubpwse")
    public suspend fun purviewConfiguration(`value`: PurviewConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purviewConfiguration = mapped
    }

    /**
     * @param argument Purview Configuration
     */
    @JvmName("xcfhggrqpealgesj")
    public suspend
    fun purviewConfiguration(argument: suspend PurviewConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PurviewConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.purviewConfiguration = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kqmfdlfqwgjochdu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Login for workspace SQL active directory administrator
     */
    @JvmName("nymyoskyqrhcywca")
    public suspend fun sqlAdministratorLogin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlAdministratorLogin = mapped
    }

    /**
     * @param value SQL administrator login password
     */
    @JvmName("kyjyxrbgpnhtsbsn")
    public suspend fun sqlAdministratorLoginPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlAdministratorLoginPassword = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("anshsksqmhfevbjr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kftnhsekqmtfqrgo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Is trustedServiceBypassEnabled for the workspace
     */
    @JvmName("qrojctvaumowpvdi")
    public suspend fun trustedServiceBypassEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedServiceBypassEnabled = mapped
    }

    /**
     * @param value Virtual Network profile
     */
    @JvmName("rvaajygcjtskmdah")
    public suspend fun virtualNetworkProfile(`value`: VirtualNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkProfile = mapped
    }

    /**
     * @param argument Virtual Network profile
     */
    @JvmName("roqpkbpiluqiwpdy")
    public suspend
    fun virtualNetworkProfile(argument: suspend VirtualNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworkProfile = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("hepqcvfgscbofjog")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    /**
     * @param value Git integration settings
     */
    @JvmName("fbdeyccgqeyhcfno")
    public suspend
    fun workspaceRepositoryConfiguration(`value`: WorkspaceRepositoryConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceRepositoryConfiguration = mapped
    }

    /**
     * @param argument Git integration settings
     */
    @JvmName("pmrygrqhoeoesxal")
    public suspend
    fun workspaceRepositoryConfiguration(argument: suspend WorkspaceRepositoryConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceRepositoryConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workspaceRepositoryConfiguration = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        azureADOnlyAuthentication = azureADOnlyAuthentication,
        cspWorkspaceAdminProperties = cspWorkspaceAdminProperties,
        defaultDataLakeStorage = defaultDataLakeStorage,
        encryption = encryption,
        identity = identity,
        location = location,
        managedResourceGroupName = managedResourceGroupName,
        managedVirtualNetwork = managedVirtualNetwork,
        managedVirtualNetworkSettings = managedVirtualNetworkSettings,
        privateEndpointConnections = privateEndpointConnections,
        publicNetworkAccess = publicNetworkAccess,
        purviewConfiguration = purviewConfiguration,
        resourceGroupName = resourceGroupName,
        sqlAdministratorLogin = sqlAdministratorLogin,
        sqlAdministratorLoginPassword = sqlAdministratorLoginPassword,
        tags = tags,
        trustedServiceBypassEnabled = trustedServiceBypassEnabled,
        virtualNetworkProfile = virtualNetworkProfile,
        workspaceName = workspaceName,
        workspaceRepositoryConfiguration = workspaceRepositoryConfiguration,
    )
}
