@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Database principal role.
 */
public enum class DatabasePrincipalRole(
    public val javaValue: com.pulumi.azurenative.synapse.enums.DatabasePrincipalRole,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.enums.DatabasePrincipalRole> {
    Admin(com.pulumi.azurenative.synapse.enums.DatabasePrincipalRole.Admin),
    Ingestor(com.pulumi.azurenative.synapse.enums.DatabasePrincipalRole.Ingestor),
    Monitor(com.pulumi.azurenative.synapse.enums.DatabasePrincipalRole.Monitor),
    User(com.pulumi.azurenative.synapse.enums.DatabasePrincipalRole.User),
    UnrestrictedViewer(com.pulumi.azurenative.synapse.enums.DatabasePrincipalRole.UnrestrictedViewer),
    Viewer(com.pulumi.azurenative.synapse.enums.DatabasePrincipalRole.Viewer),
    ;

    override fun toJava(): com.pulumi.azurenative.synapse.enums.DatabasePrincipalRole = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.enums.DatabasePrincipalRole):
            DatabasePrincipalRole = DatabasePrincipalRole.values().first { it.javaValue == javaType }
    }
}
