@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.AutoPausePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Auto-pausing properties of a Big Data pool powered by Apache Spark
 * @property delayInMinutes Number of minutes of idle time before the Big Data pool is automatically paused.
 * @property enabled Whether auto-pausing is enabled for the Big Data pool.
 */
public data class AutoPausePropertiesArgs(
    public val delayInMinutes: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.AutoPausePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.AutoPausePropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.AutoPausePropertiesArgs.builder()
            .delayInMinutes(delayInMinutes?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoPausePropertiesArgs].
 */
@PulumiTagMarker
public class AutoPausePropertiesArgsBuilder internal constructor() {
    private var delayInMinutes: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Number of minutes of idle time before the Big Data pool is automatically paused.
     */
    @JvmName("flftkuwggfwqociw")
    public suspend fun delayInMinutes(`value`: Output<Int>) {
        this.delayInMinutes = value
    }

    /**
     * @param value Whether auto-pausing is enabled for the Big Data pool.
     */
    @JvmName("hxuedjalaxgnudyb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Number of minutes of idle time before the Big Data pool is automatically paused.
     */
    @JvmName("vffnjnpfvihlirth")
    public suspend fun delayInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delayInMinutes = mapped
    }

    /**
     * @param value Whether auto-pausing is enabled for the Big Data pool.
     */
    @JvmName("xxcsjeaibjfuebgu")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): AutoPausePropertiesArgs = AutoPausePropertiesArgs(
        delayInMinutes = delayInMinutes,
        enabled = enabled,
    )
}
