@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.AutoScalePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Auto-scaling properties of a Big Data pool powered by Apache Spark
 * @property enabled Whether automatic scaling is enabled for the Big Data pool.
 * @property maxNodeCount The maximum number of nodes the Big Data pool can support.
 * @property minNodeCount The minimum number of nodes the Big Data pool can support.
 */
public data class AutoScalePropertiesArgs(
    public val enabled: Output<Boolean>? = null,
    public val maxNodeCount: Output<Int>? = null,
    public val minNodeCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.AutoScalePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.AutoScalePropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.AutoScalePropertiesArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .maxNodeCount(maxNodeCount?.applyValue({ args0 -> args0 }))
            .minNodeCount(minNodeCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoScalePropertiesArgs].
 */
@PulumiTagMarker
public class AutoScalePropertiesArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var maxNodeCount: Output<Int>? = null

    private var minNodeCount: Output<Int>? = null

    /**
     * @param value Whether automatic scaling is enabled for the Big Data pool.
     */
    @JvmName("vupnmbdtknmhcogw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The maximum number of nodes the Big Data pool can support.
     */
    @JvmName("calvjtptilckousv")
    public suspend fun maxNodeCount(`value`: Output<Int>) {
        this.maxNodeCount = value
    }

    /**
     * @param value The minimum number of nodes the Big Data pool can support.
     */
    @JvmName("ircxxsloxjofnjsv")
    public suspend fun minNodeCount(`value`: Output<Int>) {
        this.minNodeCount = value
    }

    /**
     * @param value Whether automatic scaling is enabled for the Big Data pool.
     */
    @JvmName("smrlcnpdvnjygjhn")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The maximum number of nodes the Big Data pool can support.
     */
    @JvmName("jvajkmrccumhktmh")
    public suspend fun maxNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxNodeCount = mapped
    }

    /**
     * @param value The minimum number of nodes the Big Data pool can support.
     */
    @JvmName("viptcyxwerdfldca")
    public suspend fun minNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minNodeCount = mapped
    }

    internal fun build(): AutoScalePropertiesArgs = AutoScalePropertiesArgs(
        enabled = enabled,
        maxNodeCount = maxNodeCount,
        minNodeCount = minNodeCount,
    )
}
