@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.CspWorkspaceAdminPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Initial workspace AAD admin properties for a CSP subscription
 * @property initialWorkspaceAdminObjectId AAD object ID of initial workspace admin
 */
public data class CspWorkspaceAdminPropertiesArgs(
    public val initialWorkspaceAdminObjectId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.CspWorkspaceAdminPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.CspWorkspaceAdminPropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.CspWorkspaceAdminPropertiesArgs.builder()
            .initialWorkspaceAdminObjectId(
                initialWorkspaceAdminObjectId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [CspWorkspaceAdminPropertiesArgs].
 */
@PulumiTagMarker
public class CspWorkspaceAdminPropertiesArgsBuilder internal constructor() {
    private var initialWorkspaceAdminObjectId: Output<String>? = null

    /**
     * @param value AAD object ID of initial workspace admin
     */
    @JvmName("yqwgcjkjgubofgpo")
    public suspend fun initialWorkspaceAdminObjectId(`value`: Output<String>) {
        this.initialWorkspaceAdminObjectId = value
    }

    /**
     * @param value AAD object ID of initial workspace admin
     */
    @JvmName("sytcoyuqvwqfxjnp")
    public suspend fun initialWorkspaceAdminObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialWorkspaceAdminObjectId = mapped
    }

    internal fun build(): CspWorkspaceAdminPropertiesArgs = CspWorkspaceAdminPropertiesArgs(
        initialWorkspaceAdminObjectId = initialWorkspaceAdminObjectId,
    )
}
