@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetIntegrationRuntimePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationRuntimeName Integration runtime name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetIntegrationRuntimePlainArgs(
    public val integrationRuntimeName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetIntegrationRuntimePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetIntegrationRuntimePlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetIntegrationRuntimePlainArgs.builder()
            .integrationRuntimeName(integrationRuntimeName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationRuntimePlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationRuntimePlainArgsBuilder internal constructor() {
    private var integrationRuntimeName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Integration runtime name
     */
    @JvmName("hosivrygmynaddjw")
    public suspend fun integrationRuntimeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationRuntimeName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aoevxvpwxytfutpa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ntfnqsuftcpuxdkv")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetIntegrationRuntimePlainArgs = GetIntegrationRuntimePlainArgs(
        integrationRuntimeName = integrationRuntimeName ?: throw
            PulumiNullFieldException("integrationRuntimeName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
