@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetIotHubDataConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataConnectionName The name of the data connection.
 * @property databaseName The name of the database in the Kusto pool.
 * @property kustoPoolName The name of the Kusto pool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetIotHubDataConnectionPlainArgs(
    public val dataConnectionName: String,
    public val databaseName: String,
    public val kustoPoolName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetIotHubDataConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetIotHubDataConnectionPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetIotHubDataConnectionPlainArgs.builder()
            .dataConnectionName(dataConnectionName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIotHubDataConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetIotHubDataConnectionPlainArgsBuilder internal constructor() {
    private var dataConnectionName: String? = null

    private var databaseName: String? = null

    private var kustoPoolName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the data connection.
     */
    @JvmName("ddnpvbepohxwoayx")
    public suspend fun dataConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataConnectionName = mapped
    }

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("afehkqslwyyymlgh")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("uxcdrpvvksshhmfw")
    public suspend fun kustoPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kustoPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ojtxwplrfehorirq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("arbeqcfoaxqgylxs")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetIotHubDataConnectionPlainArgs = GetIotHubDataConnectionPlainArgs(
        dataConnectionName = dataConnectionName ?: throw PulumiNullFieldException("dataConnectionName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        kustoPoolName = kustoPoolName ?: throw PulumiNullFieldException("kustoPoolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
