@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetKustoPoolAttachedDatabaseConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attachedDatabaseConfigurationName The name of the attached database configuration.
 * @property kustoPoolName The name of the Kusto pool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetKustoPoolAttachedDatabaseConfigurationPlainArgs(
    public val attachedDatabaseConfigurationName: String,
    public val kustoPoolName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetKustoPoolAttachedDatabaseConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.GetKustoPoolAttachedDatabaseConfigurationPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetKustoPoolAttachedDatabaseConfigurationPlainArgs.builder()
            .attachedDatabaseConfigurationName(attachedDatabaseConfigurationName.let({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKustoPoolAttachedDatabaseConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetKustoPoolAttachedDatabaseConfigurationPlainArgsBuilder internal constructor() {
    private var attachedDatabaseConfigurationName: String? = null

    private var kustoPoolName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the attached database configuration.
     */
    @JvmName("efxggnrpxnadhixd")
    public suspend fun attachedDatabaseConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attachedDatabaseConfigurationName = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("njeytlfcljmpfjxa")
    public suspend fun kustoPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kustoPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hxdwtaooxajnubuy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("xesdlyahphvouuuh")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetKustoPoolAttachedDatabaseConfigurationPlainArgs =
        GetKustoPoolAttachedDatabaseConfigurationPlainArgs(
            attachedDatabaseConfigurationName = attachedDatabaseConfigurationName ?: throw
                PulumiNullFieldException("attachedDatabaseConfigurationName"),
            kustoPoolName = kustoPoolName ?: throw PulumiNullFieldException("kustoPoolName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
