@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetSqlPoolTransparentDataEncryptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sqlPoolName SQL pool name
 * @property transparentDataEncryptionName The name of the transparent data encryption configuration.
 * @property workspaceName The name of the workspace.
 */
public data class GetSqlPoolTransparentDataEncryptionPlainArgs(
    public val resourceGroupName: String,
    public val sqlPoolName: String,
    public val transparentDataEncryptionName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetSqlPoolTransparentDataEncryptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.GetSqlPoolTransparentDataEncryptionPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetSqlPoolTransparentDataEncryptionPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName.let({ args0 -> args0 }))
            .transparentDataEncryptionName(transparentDataEncryptionName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlPoolTransparentDataEncryptionPlainArgs].
 */
@PulumiTagMarker
public class GetSqlPoolTransparentDataEncryptionPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sqlPoolName: String? = null

    private var transparentDataEncryptionName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lhicdqcubuafoxna")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("oadxdmubsjkidivf")
    public suspend fun sqlPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The name of the transparent data encryption configuration.
     */
    @JvmName("yfkhxxeajhaivies")
    public suspend fun transparentDataEncryptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transparentDataEncryptionName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("xwskwnutpounhevm")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetSqlPoolTransparentDataEncryptionPlainArgs =
        GetSqlPoolTransparentDataEncryptionPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sqlPoolName = sqlPoolName ?: throw PulumiNullFieldException("sqlPoolName"),
            transparentDataEncryptionName = transparentDataEncryptionName ?: throw
                PulumiNullFieldException("transparentDataEncryptionName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
