@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeDataFlowPropertiesArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.DataFlowComputeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data flow properties for managed integration runtime.
 * @property computeType Compute type of the cluster which will execute data flow job.
 * @property coreCount Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
 * @property timeToLive Time to live (in minutes) setting of the cluster which will execute data flow job.
 */
public data class IntegrationRuntimeDataFlowPropertiesArgs(
    public val computeType: Output<Either<String, DataFlowComputeType>>? = null,
    public val coreCount: Output<Int>? = null,
    public val timeToLive: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeDataFlowPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeDataFlowPropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeDataFlowPropertiesArgs.builder()
            .computeType(
                computeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .coreCount(coreCount?.applyValue({ args0 -> args0 }))
            .timeToLive(timeToLive?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationRuntimeDataFlowPropertiesArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeDataFlowPropertiesArgsBuilder internal constructor() {
    private var computeType: Output<Either<String, DataFlowComputeType>>? = null

    private var coreCount: Output<Int>? = null

    private var timeToLive: Output<Int>? = null

    /**
     * @param value Compute type of the cluster which will execute data flow job.
     */
    @JvmName("sbfoxgprpdutdikd")
    public suspend fun computeType(`value`: Output<Either<String, DataFlowComputeType>>) {
        this.computeType = value
    }

    /**
     * @param value Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
     */
    @JvmName("rytxrubethbmotpf")
    public suspend fun coreCount(`value`: Output<Int>) {
        this.coreCount = value
    }

    /**
     * @param value Time to live (in minutes) setting of the cluster which will execute data flow job.
     */
    @JvmName("qofjiufheocfxsjh")
    public suspend fun timeToLive(`value`: Output<Int>) {
        this.timeToLive = value
    }

    /**
     * @param value Compute type of the cluster which will execute data flow job.
     */
    @JvmName("ktmblsirvssxcysk")
    public suspend fun computeType(`value`: Either<String, DataFlowComputeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value Compute type of the cluster which will execute data flow job.
     */
    @JvmName("alcvfptxjpdrkiqu")
    public fun computeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataFlowComputeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value Compute type of the cluster which will execute data flow job.
     */
    @JvmName("cajfuqrrxkvalpla")
    public fun computeType(`value`: DataFlowComputeType) {
        val toBeMapped = Either.ofRight<String, DataFlowComputeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
     */
    @JvmName("mkkltiyrdcyxgcbe")
    public suspend fun coreCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreCount = mapped
    }

    /**
     * @param value Time to live (in minutes) setting of the cluster which will execute data flow job.
     */
    @JvmName("oflxpkldjdcictip")
    public suspend fun timeToLive(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeToLive = mapped
    }

    internal fun build(): IntegrationRuntimeDataFlowPropertiesArgs =
        IntegrationRuntimeDataFlowPropertiesArgs(
            computeType = computeType,
            coreCount = coreCount,
            timeToLive = timeToLive,
        )
}
