@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.ManagedVirtualNetworkSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Managed Virtual Network Settings
 * @property allowedAadTenantIdsForLinking Allowed Aad Tenant Ids For Linking
 * @property linkedAccessCheckOnTargetResource Linked Access Check On Target Resource
 * @property preventDataExfiltration Prevent Data Exfiltration
 */
public data class ManagedVirtualNetworkSettingsArgs(
    public val allowedAadTenantIdsForLinking: Output<List<String>>? = null,
    public val linkedAccessCheckOnTargetResource: Output<Boolean>? = null,
    public val preventDataExfiltration: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.ManagedVirtualNetworkSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.ManagedVirtualNetworkSettingsArgs =
        com.pulumi.azurenative.synapse.inputs.ManagedVirtualNetworkSettingsArgs.builder()
            .allowedAadTenantIdsForLinking(
                allowedAadTenantIdsForLinking?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .linkedAccessCheckOnTargetResource(
                linkedAccessCheckOnTargetResource?.applyValue({ args0 ->
                    args0
                }),
            )
            .preventDataExfiltration(preventDataExfiltration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedVirtualNetworkSettingsArgs].
 */
@PulumiTagMarker
public class ManagedVirtualNetworkSettingsArgsBuilder internal constructor() {
    private var allowedAadTenantIdsForLinking: Output<List<String>>? = null

    private var linkedAccessCheckOnTargetResource: Output<Boolean>? = null

    private var preventDataExfiltration: Output<Boolean>? = null

    /**
     * @param value Allowed Aad Tenant Ids For Linking
     */
    @JvmName("thrvvftratxohpoe")
    public suspend fun allowedAadTenantIdsForLinking(`value`: Output<List<String>>) {
        this.allowedAadTenantIdsForLinking = value
    }

    @JvmName("yidpmgciqdhsdchh")
    public suspend fun allowedAadTenantIdsForLinking(vararg values: Output<String>) {
        this.allowedAadTenantIdsForLinking = Output.all(values.asList())
    }

    /**
     * @param values Allowed Aad Tenant Ids For Linking
     */
    @JvmName("adoaydcfnpxhjhhh")
    public suspend fun allowedAadTenantIdsForLinking(values: List<Output<String>>) {
        this.allowedAadTenantIdsForLinking = Output.all(values)
    }

    /**
     * @param value Linked Access Check On Target Resource
     */
    @JvmName("vsjextfdyexaisph")
    public suspend fun linkedAccessCheckOnTargetResource(`value`: Output<Boolean>) {
        this.linkedAccessCheckOnTargetResource = value
    }

    /**
     * @param value Prevent Data Exfiltration
     */
    @JvmName("psgfvdlbcgqmcpod")
    public suspend fun preventDataExfiltration(`value`: Output<Boolean>) {
        this.preventDataExfiltration = value
    }

    /**
     * @param value Allowed Aad Tenant Ids For Linking
     */
    @JvmName("mnfbcdhtoaydhths")
    public suspend fun allowedAadTenantIdsForLinking(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedAadTenantIdsForLinking = mapped
    }

    /**
     * @param values Allowed Aad Tenant Ids For Linking
     */
    @JvmName("ufulvsiddvxeywfq")
    public suspend fun allowedAadTenantIdsForLinking(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedAadTenantIdsForLinking = mapped
    }

    /**
     * @param value Linked Access Check On Target Resource
     */
    @JvmName("rnftdqfkfodswjlb")
    public suspend fun linkedAccessCheckOnTargetResource(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedAccessCheckOnTargetResource = mapped
    }

    /**
     * @param value Prevent Data Exfiltration
     */
    @JvmName("hxkbahowmcdwiktn")
    public suspend fun preventDataExfiltration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preventDataExfiltration = mapped
    }

    internal fun build(): ManagedVirtualNetworkSettingsArgs = ManagedVirtualNetworkSettingsArgs(
        allowedAadTenantIdsForLinking = allowedAadTenantIdsForLinking,
        linkedAccessCheckOnTargetResource = linkedAccessCheckOnTargetResource,
        preventDataExfiltration = preventDataExfiltration,
    )
}
