@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.WorkspaceKeyDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the customer managed key associated with the workspace
 * @property keyVaultUrl Workspace Key sub-resource key vault url
 * @property name Workspace Key sub-resource name
 */
public data class WorkspaceKeyDetailsArgs(
    public val keyVaultUrl: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.WorkspaceKeyDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.WorkspaceKeyDetailsArgs =
        com.pulumi.azurenative.synapse.inputs.WorkspaceKeyDetailsArgs.builder()
            .keyVaultUrl(keyVaultUrl?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceKeyDetailsArgs].
 */
@PulumiTagMarker
public class WorkspaceKeyDetailsArgsBuilder internal constructor() {
    private var keyVaultUrl: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Workspace Key sub-resource key vault url
     */
    @JvmName("ljlvcthmswtpnowq")
    public suspend fun keyVaultUrl(`value`: Output<String>) {
        this.keyVaultUrl = value
    }

    /**
     * @param value Workspace Key sub-resource name
     */
    @JvmName("jhgctjgjqnkywynl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Workspace Key sub-resource key vault url
     */
    @JvmName("sjnejulrvddhvyhr")
    public suspend fun keyVaultUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUrl = mapped
    }

    /**
     * @param value Workspace Key sub-resource name
     */
    @JvmName("ystqxtjdsqgplneh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): WorkspaceKeyDetailsArgs = WorkspaceKeyDetailsArgs(
        keyVaultUrl = keyVaultUrl,
        name = name,
    )
}
