@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Dynamic Executor Allocation Properties
 * @property enabled Indicates whether Dynamic Executor Allocation is enabled or not.
 * @property maxExecutors The maximum number of executors alloted
 * @property minExecutors The minimum number of executors alloted
 */
public data class DynamicExecutorAllocationResponse(
    public val enabled: Boolean? = null,
    public val maxExecutors: Int? = null,
    public val minExecutors: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.DynamicExecutorAllocationResponse):
            DynamicExecutorAllocationResponse = DynamicExecutorAllocationResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            maxExecutors = javaType.maxExecutors().map({ args0 -> args0 }).orElse(null),
            minExecutors = javaType.minExecutors().map({ args0 -> args0 }).orElse(null),
        )
    }
}
