@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A workspace key
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isActiveCMK Used to activate the workspace after a customer managed key is provided.
 * @property keyVaultUrl The Key Vault Url of the workspace key.
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetKeyResult(
    public val id: String,
    public val isActiveCMK: Boolean? = null,
    public val keyVaultUrl: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetKeyResult): GetKeyResult =
            GetKeyResult(
                id = javaType.id(),
                isActiveCMK = javaType.isActiveCMK().map({ args0 -> args0 }).orElse(null),
                keyVaultUrl = javaType.keyVaultUrl().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                type = javaType.type(),
            )
    }
}
