@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The definition and properties of virtual network to which Azure-SSIS integration runtime will join.
 * @property subnetId The ID of subnet to which Azure-SSIS integration runtime will join.
 */
public data class IntegrationRuntimeCustomerVirtualNetworkResponse(
    public val subnetId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.IntegrationRuntimeCustomerVirtualNetworkResponse):
            IntegrationRuntimeCustomerVirtualNetworkResponse =
            IntegrationRuntimeCustomerVirtualNetworkResponse(
                subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
