@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * SQL pool SKU
 * @property capacity If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
 * @property name The SKU name
 * @property tier The service tier
 */
public data class SkuResponse(
    public val capacity: Int? = null,
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
            )
    }
}
