@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin

import com.pulumi.azurenative.testbase.ActionRequestArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.RequestTypes
import com.pulumi.azurenative.testbase.kotlin.inputs.PreReleaseAccessRequestSpecArgs
import com.pulumi.azurenative.testbase.kotlin.inputs.PreReleaseAccessRequestSpecArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### ActionRequestPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var actionRequest = new AzureNative.TestBase.ActionRequest("actionRequest", new()
 *     {
 *         ActionRequestName = "167184141414254",
 *         ResourceGroupName = "contoso-rg",
 *         TestBaseAccountName = "contoso-testBaseAccount",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/testbase/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := testbase.NewActionRequest(ctx, "actionRequest", &testbase.ActionRequestArgs{
 * 			ActionRequestName:   pulumi.String("167184141414254"),
 * 			ResourceGroupName:   pulumi.String("contoso-rg"),
 * 			TestBaseAccountName: pulumi.String("contoso-testBaseAccount"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.testbase.ActionRequest;
 * import com.pulumi.azurenative.testbase.ActionRequestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var actionRequest = new ActionRequest("actionRequest", ActionRequestArgs.builder()
 *             .actionRequestName("167184141414254")
 *             .resourceGroupName("contoso-rg")
 *             .testBaseAccountName("contoso-testBaseAccount")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:testbase:ActionRequest 167184141414254 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/actionRequests/{actionRequestName}
 * ```
 * @property actionRequestName
 * @property preReleaseAccessRequestSpec
 * @property requestType
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class ActionRequestArgs(
    public val actionRequestName: Output<String>? = null,
    public val preReleaseAccessRequestSpec: Output<PreReleaseAccessRequestSpecArgs>? = null,
    public val requestType: Output<Either<String, RequestTypes>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val testBaseAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.ActionRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.ActionRequestArgs =
        com.pulumi.azurenative.testbase.ActionRequestArgs.builder()
            .actionRequestName(actionRequestName?.applyValue({ args0 -> args0 }))
            .preReleaseAccessRequestSpec(
                preReleaseAccessRequestSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .requestType(
                requestType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActionRequestArgs].
 */
@PulumiTagMarker
public class ActionRequestArgsBuilder internal constructor() {
    private var actionRequestName: Output<String>? = null

    private var preReleaseAccessRequestSpec: Output<PreReleaseAccessRequestSpecArgs>? = null

    private var requestType: Output<Either<String, RequestTypes>>? = null

    private var resourceGroupName: Output<String>? = null

    private var testBaseAccountName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("cllbpnpitpnjptlu")
    public suspend fun actionRequestName(`value`: Output<String>) {
        this.actionRequestName = value
    }

    /**
     * @param value
     */
    @JvmName("hxlqnoguncxpsblh")
    public suspend fun preReleaseAccessRequestSpec(`value`: Output<PreReleaseAccessRequestSpecArgs>) {
        this.preReleaseAccessRequestSpec = value
    }

    /**
     * @param value
     */
    @JvmName("iemhabjcfonrnylw")
    public suspend fun requestType(`value`: Output<Either<String, RequestTypes>>) {
        this.requestType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jtdsaewdwtlsnubt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("jqqlikuwidqesmws")
    public suspend fun testBaseAccountName(`value`: Output<String>) {
        this.testBaseAccountName = value
    }

    /**
     * @param value
     */
    @JvmName("ghybwegakifgfqpn")
    public suspend fun actionRequestName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionRequestName = mapped
    }

    /**
     * @param value
     */
    @JvmName("aexmlkbinlgdjuyo")
    public suspend fun preReleaseAccessRequestSpec(`value`: PreReleaseAccessRequestSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preReleaseAccessRequestSpec = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bjlmuapiqnoetdkk")
    public suspend
    fun preReleaseAccessRequestSpec(argument: suspend PreReleaseAccessRequestSpecArgsBuilder.() -> Unit) {
        val toBeMapped = PreReleaseAccessRequestSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.preReleaseAccessRequestSpec = mapped
    }

    /**
     * @param value
     */
    @JvmName("mflnxapdkhfurylo")
    public suspend fun requestType(`value`: Either<String, RequestTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestType = mapped
    }

    /**
     * @param value
     */
    @JvmName("vmtvouqfldtgojtn")
    public fun requestType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RequestTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestType = mapped
    }

    /**
     * @param value
     */
    @JvmName("pkwwpvdirjvjsied")
    public fun requestType(`value`: RequestTypes) {
        val toBeMapped = Either.ofRight<String, RequestTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vlkrfnjvbxbaasfq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("vhsdxkpybnsumtsa")
    public suspend fun testBaseAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testBaseAccountName = mapped
    }

    internal fun build(): ActionRequestArgs = ActionRequestArgs(
        actionRequestName = actionRequestName,
        preReleaseAccessRequestSpec = preReleaseAccessRequestSpec,
        requestType = requestType,
        resourceGroupName = resourceGroupName,
        testBaseAccountName = testBaseAccountName,
    )
}
