@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The action of the command.
 */
public enum class Action(
    public val javaValue: com.pulumi.azurenative.testbase.enums.Action,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.enums.Action> {
    Install(com.pulumi.azurenative.testbase.enums.Action.Install),
    Launch(com.pulumi.azurenative.testbase.enums.Action.Launch),
    Close(com.pulumi.azurenative.testbase.enums.Action.Close),
    Uninstall(com.pulumi.azurenative.testbase.enums.Action.Uninstall),
    Custom(com.pulumi.azurenative.testbase.enums.Action.Custom),
    ;

    override fun toJava(): com.pulumi.azurenative.testbase.enums.Action = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.enums.Action): Action =
            Action.values().first { it.javaValue == javaType }
    }
}
