@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of command content.
 */
public enum class ContentType(
    public val javaValue: com.pulumi.azurenative.testbase.enums.ContentType,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.enums.ContentType> {
    Inline(com.pulumi.azurenative.testbase.enums.ContentType.Inline),
    File(com.pulumi.azurenative.testbase.enums.ContentType.File),
    Path(com.pulumi.azurenative.testbase.enums.ContentType.Path),
    ;

    override fun toJava(): com.pulumi.azurenative.testbase.enums.ContentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.enums.ContentType): ContentType =
            ContentType.values().first { it.javaValue == javaType }
    }
}
