@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Credential type.
 */
public enum class CredentialType(
    public val javaValue: com.pulumi.azurenative.testbase.enums.CredentialType,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.enums.CredentialType> {
    /**
     * Username password credential for intune enrollment.
     */
    IntuneAccount(com.pulumi.azurenative.testbase.enums.CredentialType.IntuneAccount),
    ;

    override fun toJava(): com.pulumi.azurenative.testbase.enums.CredentialType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.enums.CredentialType):
            CredentialType = CredentialType.values().first { it.javaValue == javaType }
    }
}
