@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.CommandArgs.builder
import com.pulumi.azurenative.testbase.kotlin.enums.Action
import com.pulumi.azurenative.testbase.kotlin.enums.ContentType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The command used in the test
 * @property action The action of the command.
 * @property alwaysRun Specifies whether to run the command even if a previous command is failed.
 * @property applyUpdateBefore Specifies whether to apply update before the command.
 * @property content The content of the command. The content depends on source type.
 * @property contentType The type of command content.
 * @property enrollIntuneBefore Specifies whether to enroll Intune before the command.
 * @property install1PAppBefore Specifies whether to install first party applications before running the command.
 * @property maxRunTime Specifies the max run time of the command.
 * @property name The name of the command.
 * @property postUpgrade Specifies whether the command is assigned to be executed after in-place upgrade.
 * @property preUpgrade Specifies whether the command is assigned to be executed before in-place upgrade.
 * @property restartAfter Specifies whether to restart the VM after the command executed.
 * @property runAsInteractive Specifies whether to run the command in interactive mode.
 * @property runElevated Specifies whether to run the command as administrator.
 */
public data class CommandArgs(
    public val action: Output<Either<String, Action>>,
    public val alwaysRun: Output<Boolean>? = null,
    public val applyUpdateBefore: Output<Boolean>? = null,
    public val content: Output<String>,
    public val contentType: Output<Either<String, ContentType>>,
    public val enrollIntuneBefore: Output<Boolean>? = null,
    public val install1PAppBefore: Output<Boolean>? = null,
    public val maxRunTime: Output<Int>? = null,
    public val name: Output<String>,
    public val postUpgrade: Output<Boolean>? = null,
    public val preUpgrade: Output<Boolean>? = null,
    public val restartAfter: Output<Boolean>? = null,
    public val runAsInteractive: Output<Boolean>? = null,
    public val runElevated: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.CommandArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.CommandArgs =
        com.pulumi.azurenative.testbase.inputs.CommandArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .alwaysRun(alwaysRun?.applyValue({ args0 -> args0 }))
            .applyUpdateBefore(applyUpdateBefore?.applyValue({ args0 -> args0 }))
            .content(content.applyValue({ args0 -> args0 }))
            .contentType(
                contentType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enrollIntuneBefore(enrollIntuneBefore?.applyValue({ args0 -> args0 }))
            .install1PAppBefore(install1PAppBefore?.applyValue({ args0 -> args0 }))
            .maxRunTime(maxRunTime?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .postUpgrade(postUpgrade?.applyValue({ args0 -> args0 }))
            .preUpgrade(preUpgrade?.applyValue({ args0 -> args0 }))
            .restartAfter(restartAfter?.applyValue({ args0 -> args0 }))
            .runAsInteractive(runAsInteractive?.applyValue({ args0 -> args0 }))
            .runElevated(runElevated?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommandArgs].
 */
@PulumiTagMarker
public class CommandArgsBuilder internal constructor() {
    private var action: Output<Either<String, Action>>? = null

    private var alwaysRun: Output<Boolean>? = null

    private var applyUpdateBefore: Output<Boolean>? = null

    private var content: Output<String>? = null

    private var contentType: Output<Either<String, ContentType>>? = null

    private var enrollIntuneBefore: Output<Boolean>? = null

    private var install1PAppBefore: Output<Boolean>? = null

    private var maxRunTime: Output<Int>? = null

    private var name: Output<String>? = null

    private var postUpgrade: Output<Boolean>? = null

    private var preUpgrade: Output<Boolean>? = null

    private var restartAfter: Output<Boolean>? = null

    private var runAsInteractive: Output<Boolean>? = null

    private var runElevated: Output<Boolean>? = null

    /**
     * @param value The action of the command.
     */
    @JvmName("hlgcymjovfhwgooh")
    public suspend fun action(`value`: Output<Either<String, Action>>) {
        this.action = value
    }

    /**
     * @param value Specifies whether to run the command even if a previous command is failed.
     */
    @JvmName("xudgfcntefglilij")
    public suspend fun alwaysRun(`value`: Output<Boolean>) {
        this.alwaysRun = value
    }

    /**
     * @param value Specifies whether to apply update before the command.
     */
    @JvmName("rhgbdldkfatqlrsw")
    public suspend fun applyUpdateBefore(`value`: Output<Boolean>) {
        this.applyUpdateBefore = value
    }

    /**
     * @param value The content of the command. The content depends on source type.
     */
    @JvmName("rtwapuxdvbjtbqfe")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The type of command content.
     */
    @JvmName("grcqqrrtypdnxjes")
    public suspend fun contentType(`value`: Output<Either<String, ContentType>>) {
        this.contentType = value
    }

    /**
     * @param value Specifies whether to enroll Intune before the command.
     */
    @JvmName("tnnueyvltvrjwkoa")
    public suspend fun enrollIntuneBefore(`value`: Output<Boolean>) {
        this.enrollIntuneBefore = value
    }

    /**
     * @param value Specifies whether to install first party applications before running the command.
     */
    @JvmName("rnntwysqthciryon")
    public suspend fun install1PAppBefore(`value`: Output<Boolean>) {
        this.install1PAppBefore = value
    }

    /**
     * @param value Specifies the max run time of the command.
     */
    @JvmName("aqeyowkvgsjhmaig")
    public suspend fun maxRunTime(`value`: Output<Int>) {
        this.maxRunTime = value
    }

    /**
     * @param value The name of the command.
     */
    @JvmName("aaiomaootgfycwae")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether the command is assigned to be executed after in-place upgrade.
     */
    @JvmName("wlkyeqmijkitnkpo")
    public suspend fun postUpgrade(`value`: Output<Boolean>) {
        this.postUpgrade = value
    }

    /**
     * @param value Specifies whether the command is assigned to be executed before in-place upgrade.
     */
    @JvmName("yspqkklvisgjjgro")
    public suspend fun preUpgrade(`value`: Output<Boolean>) {
        this.preUpgrade = value
    }

    /**
     * @param value Specifies whether to restart the VM after the command executed.
     */
    @JvmName("yxbaspcwlpkbnxdk")
    public suspend fun restartAfter(`value`: Output<Boolean>) {
        this.restartAfter = value
    }

    /**
     * @param value Specifies whether to run the command in interactive mode.
     */
    @JvmName("iklqoobwqqjapkqa")
    public suspend fun runAsInteractive(`value`: Output<Boolean>) {
        this.runAsInteractive = value
    }

    /**
     * @param value Specifies whether to run the command as administrator.
     */
    @JvmName("gfwghvblbwmcohhh")
    public suspend fun runElevated(`value`: Output<Boolean>) {
        this.runElevated = value
    }

    /**
     * @param value The action of the command.
     */
    @JvmName("ojxhilnreodxdmid")
    public suspend fun action(`value`: Either<String, Action>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The action of the command.
     */
    @JvmName("aqwesrjaiiskdiof")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Action>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The action of the command.
     */
    @JvmName("arvyidkiuocpcnli")
    public fun action(`value`: Action) {
        val toBeMapped = Either.ofRight<String, Action>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Specifies whether to run the command even if a previous command is failed.
     */
    @JvmName("jtmjttmsyylvmfkd")
    public suspend fun alwaysRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alwaysRun = mapped
    }

    /**
     * @param value Specifies whether to apply update before the command.
     */
    @JvmName("kvenpradgyyqfkee")
    public suspend fun applyUpdateBefore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyUpdateBefore = mapped
    }

    /**
     * @param value The content of the command. The content depends on source type.
     */
    @JvmName("nkqsnolubrngtncd")
    public suspend fun content(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The type of command content.
     */
    @JvmName("nxqgldykhmjsmket")
    public suspend fun contentType(`value`: Either<String, ContentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The type of command content.
     */
    @JvmName("ckxtpdfafwhrqxlr")
    public fun contentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The type of command content.
     */
    @JvmName("anhwpwnalgimugep")
    public fun contentType(`value`: ContentType) {
        val toBeMapped = Either.ofRight<String, ContentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Specifies whether to enroll Intune before the command.
     */
    @JvmName("rsxnswaadoyosksq")
    public suspend fun enrollIntuneBefore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enrollIntuneBefore = mapped
    }

    /**
     * @param value Specifies whether to install first party applications before running the command.
     */
    @JvmName("jfgvcdgewnihdtxx")
    public suspend fun install1PAppBefore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.install1PAppBefore = mapped
    }

    /**
     * @param value Specifies the max run time of the command.
     */
    @JvmName("cbiihseesjiliapa")
    public suspend fun maxRunTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRunTime = mapped
    }

    /**
     * @param value The name of the command.
     */
    @JvmName("gennsvhndnlrjqvl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether the command is assigned to be executed after in-place upgrade.
     */
    @JvmName("iutyxmucotsmllva")
    public suspend fun postUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postUpgrade = mapped
    }

    /**
     * @param value Specifies whether the command is assigned to be executed before in-place upgrade.
     */
    @JvmName("sqvxsfhkreyxaapl")
    public suspend fun preUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preUpgrade = mapped
    }

    /**
     * @param value Specifies whether to restart the VM after the command executed.
     */
    @JvmName("aacbvhrinlchqccf")
    public suspend fun restartAfter(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartAfter = mapped
    }

    /**
     * @param value Specifies whether to run the command in interactive mode.
     */
    @JvmName("fvbotfgubadqlmlu")
    public suspend fun runAsInteractive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsInteractive = mapped
    }

    /**
     * @param value Specifies whether to run the command as administrator.
     */
    @JvmName("iqskmrnkytvuhugw")
    public suspend fun runElevated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runElevated = mapped
    }

    internal fun build(): CommandArgs = CommandArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        alwaysRun = alwaysRun,
        applyUpdateBefore = applyUpdateBefore,
        content = content ?: throw PulumiNullFieldException("content"),
        contentType = contentType ?: throw PulumiNullFieldException("contentType"),
        enrollIntuneBefore = enrollIntuneBefore,
        install1PAppBefore = install1PAppBefore,
        maxRunTime = maxRunTime,
        name = name ?: throw PulumiNullFieldException("name"),
        postUpgrade = postUpgrade,
        preUpgrade = preUpgrade,
        restartAfter = restartAfter,
        runAsInteractive = runAsInteractive,
        runElevated = runElevated,
    )
}
