@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GetFavoriteProcessPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property favoriteProcessResourceName The resource name of a favorite process in a package. If the process name contains characters that are not allowed in Azure Resource Name, we use 'actualProcessName' in request body to submit the name.
 * @property packageName The resource name of the Test Base Package.
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class GetFavoriteProcessPlainArgs(
    public val favoriteProcessResourceName: String,
    public val packageName: String,
    public val resourceGroupName: String,
    public val testBaseAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GetFavoriteProcessPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.GetFavoriteProcessPlainArgs =
        com.pulumi.azurenative.testbase.inputs.GetFavoriteProcessPlainArgs.builder()
            .favoriteProcessResourceName(favoriteProcessResourceName.let({ args0 -> args0 }))
            .packageName(packageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFavoriteProcessPlainArgs].
 */
@PulumiTagMarker
public class GetFavoriteProcessPlainArgsBuilder internal constructor() {
    private var favoriteProcessResourceName: String? = null

    private var packageName: String? = null

    private var resourceGroupName: String? = null

    private var testBaseAccountName: String? = null

    /**
     * @param value The resource name of a favorite process in a package. If the process name contains characters that are not allowed in Azure Resource Name, we use 'actualProcessName' in request body to submit the name.
     */
    @JvmName("ipjvvtmybchoclas")
    public suspend fun favoriteProcessResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.favoriteProcessResourceName = mapped
    }

    /**
     * @param value The resource name of the Test Base Package.
     */
    @JvmName("dkcsyjcgvccwytix")
    public suspend fun packageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packageName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("htnuovjopylmspdu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("tofvvigwikkbucir")
    public suspend fun testBaseAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testBaseAccountName = mapped
    }

    internal fun build(): GetFavoriteProcessPlainArgs = GetFavoriteProcessPlainArgs(
        favoriteProcessResourceName = favoriteProcessResourceName ?: throw
            PulumiNullFieldException("favoriteProcessResourceName"),
        packageName = packageName ?: throw PulumiNullFieldException("packageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        testBaseAccountName = testBaseAccountName ?: throw PulumiNullFieldException("testBaseAccountName"),
    )
}
