@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GetPackageDownloadURLPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property packageName The resource name of the Test Base Package.
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property testBaseAccountName The resource name of the Test Base Account.
 */
public data class GetPackageDownloadURLPlainArgs(
    public val packageName: String,
    public val resourceGroupName: String,
    public val testBaseAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GetPackageDownloadURLPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.GetPackageDownloadURLPlainArgs =
        com.pulumi.azurenative.testbase.inputs.GetPackageDownloadURLPlainArgs.builder()
            .packageName(packageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPackageDownloadURLPlainArgs].
 */
@PulumiTagMarker
public class GetPackageDownloadURLPlainArgsBuilder internal constructor() {
    private var packageName: String? = null

    private var resourceGroupName: String? = null

    private var testBaseAccountName: String? = null

    /**
     * @param value The resource name of the Test Base Package.
     */
    @JvmName("eeoubyetlkdngcpn")
    public suspend fun packageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packageName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("asbrjfuhopdljhbb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("pumxkweuodnkhppm")
    public suspend fun testBaseAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testBaseAccountName = mapped
    }

    internal fun build(): GetPackageDownloadURLPlainArgs = GetPackageDownloadURLPlainArgs(
        packageName = packageName ?: throw PulumiNullFieldException("packageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        testBaseAccountName = testBaseAccountName ?: throw PulumiNullFieldException("testBaseAccountName"),
    )
}
