@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.GetTestResultConsoleLogDownloadURLPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logFileName The log file name corresponding to the download URL.
 * @property packageName The resource name of the Test Base Package.
 * @property resourceGroupName The name of the resource group that contains the resource.
 * @property testBaseAccountName The resource name of the Test Base Account.
 * @property testResultName The Test Result Name. It equals to TestResult-{TestResultId} string.
 */
public data class GetTestResultConsoleLogDownloadURLPlainArgs(
    public val logFileName: String,
    public val packageName: String,
    public val resourceGroupName: String,
    public val testBaseAccountName: String,
    public val testResultName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.GetTestResultConsoleLogDownloadURLPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.testbase.inputs.GetTestResultConsoleLogDownloadURLPlainArgs =
        com.pulumi.azurenative.testbase.inputs.GetTestResultConsoleLogDownloadURLPlainArgs.builder()
            .logFileName(logFileName.let({ args0 -> args0 }))
            .packageName(packageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .testBaseAccountName(testBaseAccountName.let({ args0 -> args0 }))
            .testResultName(testResultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTestResultConsoleLogDownloadURLPlainArgs].
 */
@PulumiTagMarker
public class GetTestResultConsoleLogDownloadURLPlainArgsBuilder internal constructor() {
    private var logFileName: String? = null

    private var packageName: String? = null

    private var resourceGroupName: String? = null

    private var testBaseAccountName: String? = null

    private var testResultName: String? = null

    /**
     * @param value The log file name corresponding to the download URL.
     */
    @JvmName("sitigkqahhbpvdgu")
    public suspend fun logFileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.logFileName = mapped
    }

    /**
     * @param value The resource name of the Test Base Package.
     */
    @JvmName("qkrlojsvjcsusxoh")
    public suspend fun packageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packageName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource.
     */
    @JvmName("rgvwjldsefksdowk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name of the Test Base Account.
     */
    @JvmName("ntoruwjgivqxciyl")
    public suspend fun testBaseAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testBaseAccountName = mapped
    }

    /**
     * @param value The Test Result Name. It equals to TestResult-{TestResultId} string.
     */
    @JvmName("vpruoaqjeorffnvt")
    public suspend fun testResultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.testResultName = mapped
    }

    internal fun build(): GetTestResultConsoleLogDownloadURLPlainArgs =
        GetTestResultConsoleLogDownloadURLPlainArgs(
            logFileName = logFileName ?: throw PulumiNullFieldException("logFileName"),
            packageName = packageName ?: throw PulumiNullFieldException("packageName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            testBaseAccountName = testBaseAccountName ?: throw PulumiNullFieldException("testBaseAccountName"),
            testResultName = testResultName ?: throw PulumiNullFieldException("testResultName"),
        )
}
