@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.inputs

import com.pulumi.azurenative.testbase.inputs.ReleasePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of an operating system release.
 * @property buildNumber The build number of the OS release.
 * @property buildRevision The build revision of the OS release.
 * @property releaseName The name of the OS release.
 * @property releaseVersionDate The release version date of the OS release.
 */
public data class ReleasePropertiesArgs(
    public val buildNumber: Output<String>? = null,
    public val buildRevision: Output<String>? = null,
    public val releaseName: Output<String>? = null,
    public val releaseVersionDate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.testbase.inputs.ReleasePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.testbase.inputs.ReleasePropertiesArgs =
        com.pulumi.azurenative.testbase.inputs.ReleasePropertiesArgs.builder()
            .buildNumber(buildNumber?.applyValue({ args0 -> args0 }))
            .buildRevision(buildRevision?.applyValue({ args0 -> args0 }))
            .releaseName(releaseName?.applyValue({ args0 -> args0 }))
            .releaseVersionDate(releaseVersionDate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReleasePropertiesArgs].
 */
@PulumiTagMarker
public class ReleasePropertiesArgsBuilder internal constructor() {
    private var buildNumber: Output<String>? = null

    private var buildRevision: Output<String>? = null

    private var releaseName: Output<String>? = null

    private var releaseVersionDate: Output<String>? = null

    /**
     * @param value The build number of the OS release.
     */
    @JvmName("hwbaodibaolqxckd")
    public suspend fun buildNumber(`value`: Output<String>) {
        this.buildNumber = value
    }

    /**
     * @param value The build revision of the OS release.
     */
    @JvmName("voqcghctmprtqkso")
    public suspend fun buildRevision(`value`: Output<String>) {
        this.buildRevision = value
    }

    /**
     * @param value The name of the OS release.
     */
    @JvmName("rdtxjodxvsetppkv")
    public suspend fun releaseName(`value`: Output<String>) {
        this.releaseName = value
    }

    /**
     * @param value The release version date of the OS release.
     */
    @JvmName("ipcnqrodqftglaok")
    public suspend fun releaseVersionDate(`value`: Output<String>) {
        this.releaseVersionDate = value
    }

    /**
     * @param value The build number of the OS release.
     */
    @JvmName("hgescvrkybdwuhkd")
    public suspend fun buildNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildNumber = mapped
    }

    /**
     * @param value The build revision of the OS release.
     */
    @JvmName("eaieojhdewxswwxv")
    public suspend fun buildRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildRevision = mapped
    }

    /**
     * @param value The name of the OS release.
     */
    @JvmName("vrgqstussctmfvtf")
    public suspend fun releaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseName = mapped
    }

    /**
     * @param value The release version date of the OS release.
     */
    @JvmName("fjvuyfbumungncgw")
    public suspend fun releaseVersionDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseVersionDate = mapped
    }

    internal fun build(): ReleasePropertiesArgs = ReleasePropertiesArgs(
        buildNumber = buildNumber,
        buildRevision = buildRevision,
        releaseName = releaseName,
        releaseVersionDate = releaseVersionDate,
    )
}
