@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Metadata of a single Intune App.
 * @property appId Intune app id.
 * @property appName Intune app name.
 * @property createDate Creation date of the app.
 * @property dependencyIds Ids of dependency apps.
 * @property dependentAppCount Count of dependency apps.
 * @property description Description of the app.
 * @property expectedExitCodes Expected exit codes returned from Intune App.
 * @property installCommand Install command.
 * @property lastProcessed last processed time tickets.
 * @property minimumSupportedOS Minimum supported OS. The OS version must be greater than this version to run this app.
 * @property owner Owner of the app.
 * @property publisher Publisher of the app.
 * @property setupFile Setup file path.
 * @property status Extract status.
 * @property uninstallCommand Uninstall command.
 * @property version Intune app version.
 */
public data class DraftPackageIntuneAppMetadataItemResponse(
    public val appId: String? = null,
    public val appName: String? = null,
    public val createDate: String? = null,
    public val dependencyIds: List<String>? = null,
    public val dependentAppCount: Int? = null,
    public val description: String? = null,
    public val expectedExitCodes: List<String>? = null,
    public val installCommand: String? = null,
    public val lastProcessed: Double? = null,
    public val minimumSupportedOS: String? = null,
    public val owner: String? = null,
    public val publisher: String? = null,
    public val setupFile: String? = null,
    public val status: String? = null,
    public val uninstallCommand: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.DraftPackageIntuneAppMetadataItemResponse):
            DraftPackageIntuneAppMetadataItemResponse = DraftPackageIntuneAppMetadataItemResponse(
            appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
            appName = javaType.appName().map({ args0 -> args0 }).orElse(null),
            createDate = javaType.createDate().map({ args0 -> args0 }).orElse(null),
            dependencyIds = javaType.dependencyIds().map({ args0 -> args0 }),
            dependentAppCount = javaType.dependentAppCount().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            expectedExitCodes = javaType.expectedExitCodes().map({ args0 -> args0 }),
            installCommand = javaType.installCommand().map({ args0 -> args0 }).orElse(null),
            lastProcessed = javaType.lastProcessed().map({ args0 -> args0 }).orElse(null),
            minimumSupportedOS = javaType.minimumSupportedOS().map({ args0 -> args0 }).orElse(null),
            owner = javaType.owner().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            setupFile = javaType.setupFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            uninstallCommand = javaType.uninstallCommand().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
