@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The information of a highlighted file that user should pay attention to.
 * @property path The path of the highlighted file.
 * @property sections The name of sections to highlight.
 * @property visited A flag to save whether this file is viewed by user.
 */
public data class HighlightedFileResponse(
    public val path: String,
    public val sections: List<String>? = null,
    public val visited: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.HighlightedFileResponse):
            HighlightedFileResponse = HighlightedFileResponse(
            path = javaType.path(),
            sections = javaType.sections().map({ args0 -> args0 }),
            visited = javaType.visited().map({ args0 -> args0 }).orElse(null),
        )
    }
}
