@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The metadata of Intune enrollment.
 * @property appList The enrolled Intune apps.
 * @property credentialId The id of the Intune enrollment credential.
 * @property expectedDeploymentDurationInMinute The expected duration of Intune applications and policies deployment.
 */
public data class IntuneEnrollmentMetadataResponse(
    public val appList: List<EnrolledIntuneAppResponse>? = null,
    public val credentialId: String? = null,
    public val expectedDeploymentDurationInMinute: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.IntuneEnrollmentMetadataResponse):
            IntuneEnrollmentMetadataResponse = IntuneEnrollmentMetadataResponse(
            appList = javaType.appList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.testbase.kotlin.outputs.EnrolledIntuneAppResponse.Companion.toKotlin(args0)
                })
            }),
            credentialId = javaType.credentialId().map({ args0 -> args0 }).orElse(null),
            expectedDeploymentDurationInMinute = javaType.expectedDeploymentDurationInMinute().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
