@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The validation results. There's validation on package when it's created or updated.
 * @property errors Error information.
 * @property isValid Indicates whether the package passed the validation.
 * @property validationName Validation name.
 */
public data class PackageValidationResultResponse(
    public val errors: List<String>,
    public val isValid: Boolean,
    public val validationName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.PackageValidationResultResponse):
            PackageValidationResultResponse = PackageValidationResultResponse(
            errors = javaType.errors().map({ args0 -> args0 }),
            isValid = javaType.isValid(),
            validationName = javaType.validationName(),
        )
    }
}
