@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.testbase.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of an operating system release.
 * @property buildNumber The build number of the OS release.
 * @property buildRevision The build revision of the OS release.
 * @property releaseName The name of the OS release.
 * @property releaseVersionDate The release version date of the OS release.
 */
public data class ReleasePropertiesResponse(
    public val buildNumber: String? = null,
    public val buildRevision: String? = null,
    public val releaseName: String? = null,
    public val releaseVersionDate: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.testbase.outputs.ReleasePropertiesResponse):
            ReleasePropertiesResponse = ReleasePropertiesResponse(
            buildNumber = javaType.buildNumber().map({ args0 -> args0 }).orElse(null),
            buildRevision = javaType.buildRevision().map({ args0 -> args0 }).orElse(null),
            releaseName = javaType.releaseName().map({ args0 -> args0 }).orElse(null),
            releaseVersionDate = javaType.releaseVersionDate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
