@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.AccessPolicyArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.enums.AccessPolicyRole
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An access policy is used to grant users and applications access to the environment. Roles are assigned to service principals in Azure Active Directory. These roles define the actions the principal can perform through the Time Series Insights data plane APIs.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * Other available API versions: 2017-11-15, 2021-06-30-preview.
 * ## Example Usage
 * ### AccessPoliciesCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var accessPolicy = new AzureNative.TimeSeriesInsights.AccessPolicy("accessPolicy", new()
 *     {
 *         AccessPolicyName = "ap1",
 *         Description = "some description",
 *         EnvironmentName = "env1",
 *         PrincipalObjectId = "aGuid",
 *         ResourceGroupName = "rg1",
 *         Roles = new[]
 *         {
 *             "Reader",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewAccessPolicy(ctx, "accessPolicy", &timeseriesinsights.AccessPolicyArgs{
 * 			AccessPolicyName:  pulumi.String("ap1"),
 * 			Description:       pulumi.String("some description"),
 * 			EnvironmentName:   pulumi.String("env1"),
 * 			PrincipalObjectId: pulumi.String("aGuid"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Roles: pulumi.StringArray{
 * 				pulumi.String("Reader"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.AccessPolicy;
 * import com.pulumi.azurenative.timeseriesinsights.AccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accessPolicy = new AccessPolicy("accessPolicy", AccessPolicyArgs.builder()
 *             .accessPolicyName("ap1")
 *             .description("some description")
 *             .environmentName("env1")
 *             .principalObjectId("aGuid")
 *             .resourceGroupName("rg1")
 *             .roles("Reader")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:AccessPolicy ap1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/accessPolicies/{accessPolicyName}
 * ```
 * @property accessPolicyName Name of the access policy.
 * @property description An description of the access policy.
 * @property environmentName The name of the Time Series Insights environment associated with the specified resource group.
 * @property principalObjectId The objectId of the principal in Azure Active Directory.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property roles The list of roles the principal is assigned on the environment.
 */
public data class AccessPolicyArgs(
    public val accessPolicyName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val principalObjectId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roles: Output<List<Either<String, AccessPolicyRole>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.AccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.AccessPolicyArgs =
        com.pulumi.azurenative.timeseriesinsights.AccessPolicyArgs.builder()
            .accessPolicyName(accessPolicyName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .principalObjectId(principalObjectId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roles(
                roles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccessPolicyArgs].
 */
@PulumiTagMarker
public class AccessPolicyArgsBuilder internal constructor() {
    private var accessPolicyName: Output<String>? = null

    private var description: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var principalObjectId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var roles: Output<List<Either<String, AccessPolicyRole>>>? = null

    /**
     * @param value Name of the access policy.
     */
    @JvmName("enpdjmmponarihff")
    public suspend fun accessPolicyName(`value`: Output<String>) {
        this.accessPolicyName = value
    }

    /**
     * @param value An description of the access policy.
     */
    @JvmName("csfgdhkkhdkrtyys")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("kcupqfghmjpkhqmr")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value The objectId of the principal in Azure Active Directory.
     */
    @JvmName("sbkltwialarfpmmw")
    public suspend fun principalObjectId(`value`: Output<String>) {
        this.principalObjectId = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("hbfrhccqjdsbtnhd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The list of roles the principal is assigned on the environment.
     */
    @JvmName("flhtckhxvvwdruea")
    public suspend fun roles(`value`: Output<List<Either<String, AccessPolicyRole>>>) {
        this.roles = value
    }

    @JvmName("mhatirvhtunejjlg")
    public suspend fun roles(vararg values: Output<Either<String, AccessPolicyRole>>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values The list of roles the principal is assigned on the environment.
     */
    @JvmName("ynrblmotkrbbujfy")
    public suspend fun roles(values: List<Output<Either<String, AccessPolicyRole>>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value Name of the access policy.
     */
    @JvmName("lhvcqmkjydriehnm")
    public suspend fun accessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicyName = mapped
    }

    /**
     * @param value An description of the access policy.
     */
    @JvmName("gjmxxvjywcacrybu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("nbmihswjxiltbphd")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The objectId of the principal in Azure Active Directory.
     */
    @JvmName("vcklljvqyntarblh")
    public suspend fun principalObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalObjectId = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("fovwlwhmgfletybr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The list of roles the principal is assigned on the environment.
     */
    @JvmName("fhkoovjsichgjusa")
    public suspend fun roles(`value`: List<Either<String, AccessPolicyRole>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values The list of roles the principal is assigned on the environment.
     */
    @JvmName("pqiabskjhjrbtimd")
    public suspend fun roles(vararg values: Either<String, AccessPolicyRole>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    internal fun build(): AccessPolicyArgs = AccessPolicyArgs(
        accessPolicyName = accessPolicyName,
        description = description,
        environmentName = environmentName,
        principalObjectId = principalObjectId,
        resourceGroupName = resourceGroupName,
        roles = roles,
    )
}
