@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.EventHubEventSourceArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.enums.IngressStartAtType
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.LocalTimestampArgs
import com.pulumi.azurenative.timeseriesinsights.kotlin.inputs.LocalTimestampArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An event source that receives its data from an Azure EventHub.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * ## Example Usage
 * ### CreateEventHubEventSource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubEventSource = new AzureNative.TimeSeriesInsights.EventHubEventSource("eventHubEventSource", new()
 *     {
 *         ConsumerGroupName = "cgn",
 *         EnvironmentName = "env1",
 *         EventHubName = "ehn",
 *         EventSourceName = "es1",
 *         EventSourceResourceId = "somePathInArm",
 *         KeyName = "managementKey",
 *         Kind = "Microsoft.EventHub",
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         ServiceBusNamespace = "sbn",
 *         SharedAccessKey = "someSecretvalue",
 *         TimestampPropertyName = "someTimestampProperty",
 *         Type = "EarliestAvailable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewEventHubEventSource(ctx, "eventHubEventSource", &timeseriesinsights.EventHubEventSourceArgs{
 * 			ConsumerGroupName:     pulumi.String("cgn"),
 * 			EnvironmentName:       pulumi.String("env1"),
 * 			EventHubName:          pulumi.String("ehn"),
 * 			EventSourceName:       pulumi.String("es1"),
 * 			EventSourceResourceId: pulumi.String("somePathInArm"),
 * 			KeyName:               pulumi.String("managementKey"),
 * 			Kind:                  pulumi.String("Microsoft.EventHub"),
 * 			Location:              pulumi.String("West US"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			ServiceBusNamespace:   pulumi.String("sbn"),
 * 			SharedAccessKey:       pulumi.String("someSecretvalue"),
 * 			TimestampPropertyName: pulumi.String("someTimestampProperty"),
 * 			Type:                  pulumi.String("EarliestAvailable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.EventHubEventSource;
 * import com.pulumi.azurenative.timeseriesinsights.EventHubEventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubEventSource = new EventHubEventSource("eventHubEventSource", EventHubEventSourceArgs.builder()
 *             .consumerGroupName("cgn")
 *             .environmentName("env1")
 *             .eventHubName("ehn")
 *             .eventSourceName("es1")
 *             .eventSourceResourceId("somePathInArm")
 *             .keyName("managementKey")
 *             .kind("Microsoft.EventHub")
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .serviceBusNamespace("sbn")
 *             .sharedAccessKey("someSecretvalue")
 *             .timestampPropertyName("someTimestampProperty")
 *             .type("EarliestAvailable")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSourcesCreateEventHubWithCustomEnquedTime
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubEventSource = new AzureNative.TimeSeriesInsights.EventHubEventSource("eventHubEventSource", new()
 *     {
 *         ConsumerGroupName = "cgn",
 *         EnvironmentName = "env1",
 *         EventHubName = "ehn",
 *         EventSourceName = "es1",
 *         EventSourceResourceId = "somePathInArm",
 *         KeyName = "managementKey",
 *         Kind = "Microsoft.EventHub",
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         ServiceBusNamespace = "sbn",
 *         SharedAccessKey = "someSecretvalue",
 *         Time = "2017-04-01T19:20:33.2288820Z",
 *         TimestampPropertyName = "someTimestampProperty",
 *         Type = "CustomEnqueuedTime",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewEventHubEventSource(ctx, "eventHubEventSource", &timeseriesinsights.EventHubEventSourceArgs{
 * 			ConsumerGroupName:     pulumi.String("cgn"),
 * 			EnvironmentName:       pulumi.String("env1"),
 * 			EventHubName:          pulumi.String("ehn"),
 * 			EventSourceName:       pulumi.String("es1"),
 * 			EventSourceResourceId: pulumi.String("somePathInArm"),
 * 			KeyName:               pulumi.String("managementKey"),
 * 			Kind:                  pulumi.String("Microsoft.EventHub"),
 * 			Location:              pulumi.String("West US"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			ServiceBusNamespace:   pulumi.String("sbn"),
 * 			SharedAccessKey:       pulumi.String("someSecretvalue"),
 * 			Time:                  pulumi.String("2017-04-01T19:20:33.2288820Z"),
 * 			TimestampPropertyName: pulumi.String("someTimestampProperty"),
 * 			Type:                  pulumi.String("CustomEnqueuedTime"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.EventHubEventSource;
 * import com.pulumi.azurenative.timeseriesinsights.EventHubEventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubEventSource = new EventHubEventSource("eventHubEventSource", EventHubEventSourceArgs.builder()
 *             .consumerGroupName("cgn")
 *             .environmentName("env1")
 *             .eventHubName("ehn")
 *             .eventSourceName("es1")
 *             .eventSourceResourceId("somePathInArm")
 *             .keyName("managementKey")
 *             .kind("Microsoft.EventHub")
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .serviceBusNamespace("sbn")
 *             .sharedAccessKey("someSecretvalue")
 *             .time("2017-04-01T19:20:33.2288820Z")
 *             .timestampPropertyName("someTimestampProperty")
 *             .type("CustomEnqueuedTime")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:EventHubEventSource es1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/eventSources/{eventSourceName}
 * ```
 * @property consumerGroupName The name of the event hub's consumer group that holds the partitions from which events will be read.
 * @property environmentName The name of the Time Series Insights environment associated with the specified resource group.
 * @property eventHubName The name of the event hub.
 * @property eventSourceName Name of the event source.
 * @property eventSourceResourceId The resource id of the event source in Azure Resource Manager.
 * @property keyName The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access policies for this key must grant 'Listen' permissions to the event hub.
 * @property kind The kind of the event source.
 * Expected value is 'Microsoft.EventHub'.
 * @property localTimestamp An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
 * @property location The location of the resource.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property serviceBusNamespace The name of the service bus that contains the event hub.
 * @property sharedAccessKey The value of the shared access key that grants the Time Series Insights service read access to the event hub. This property is not shown in event source responses.
 * @property tags Key-value pairs of additional properties for the resource.
 * @property time ISO8601 UTC datetime with seconds precision (milliseconds are optional), specifying the date and time that will be the starting point for Events to be consumed.
 * @property timestampPropertyName The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
 * @property type The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
 */
public data class EventHubEventSourceArgs(
    public val consumerGroupName: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val eventHubName: Output<String>? = null,
    public val eventSourceName: Output<String>? = null,
    public val eventSourceResourceId: Output<String>? = null,
    public val keyName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val localTimestamp: Output<LocalTimestampArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceBusNamespace: Output<String>? = null,
    public val sharedAccessKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val time: Output<String>? = null,
    public val timestampPropertyName: Output<String>? = null,
    public val type: Output<Either<String, IngressStartAtType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.EventHubEventSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.EventHubEventSourceArgs =
        com.pulumi.azurenative.timeseriesinsights.EventHubEventSourceArgs.builder()
            .consumerGroupName(consumerGroupName?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .eventSourceName(eventSourceName?.applyValue({ args0 -> args0 }))
            .eventSourceResourceId(eventSourceResourceId?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .localTimestamp(localTimestamp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceBusNamespace(serviceBusNamespace?.applyValue({ args0 -> args0 }))
            .sharedAccessKey(sharedAccessKey?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .time(time?.applyValue({ args0 -> args0 }))
            .timestampPropertyName(timestampPropertyName?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventHubEventSourceArgs].
 */
@PulumiTagMarker
public class EventHubEventSourceArgsBuilder internal constructor() {
    private var consumerGroupName: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var eventHubName: Output<String>? = null

    private var eventSourceName: Output<String>? = null

    private var eventSourceResourceId: Output<String>? = null

    private var keyName: Output<String>? = null

    private var kind: Output<String>? = null

    private var localTimestamp: Output<LocalTimestampArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceBusNamespace: Output<String>? = null

    private var sharedAccessKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var time: Output<String>? = null

    private var timestampPropertyName: Output<String>? = null

    private var type: Output<Either<String, IngressStartAtType>>? = null

    /**
     * @param value The name of the event hub's consumer group that holds the partitions from which events will be read.
     */
    @JvmName("onympwvgsuklqgyv")
    public suspend fun consumerGroupName(`value`: Output<String>) {
        this.consumerGroupName = value
    }

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("essfaymceysvnywv")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value The name of the event hub.
     */
    @JvmName("wxxvioenduhetqiv")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value Name of the event source.
     */
    @JvmName("pnlsvnouxnkdniph")
    public suspend fun eventSourceName(`value`: Output<String>) {
        this.eventSourceName = value
    }

    /**
     * @param value The resource id of the event source in Azure Resource Manager.
     */
    @JvmName("rmqvlylusvqbntot")
    public suspend fun eventSourceResourceId(`value`: Output<String>) {
        this.eventSourceResourceId = value
    }

    /**
     * @param value The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access policies for this key must grant 'Listen' permissions to the event hub.
     */
    @JvmName("oxnighuqigiadbkk")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The kind of the event source.
     * Expected value is 'Microsoft.EventHub'.
     */
    @JvmName("wjpdimmwadhdmogr")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
     */
    @JvmName("bhrkspigfcxvipnp")
    public suspend fun localTimestamp(`value`: Output<LocalTimestampArgs>) {
        this.localTimestamp = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("yrqreeguafnkpuwd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("rwohxdhiyucbyjgr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the service bus that contains the event hub.
     */
    @JvmName("quggwuaqwlumooge")
    public suspend fun serviceBusNamespace(`value`: Output<String>) {
        this.serviceBusNamespace = value
    }

    /**
     * @param value The value of the shared access key that grants the Time Series Insights service read access to the event hub. This property is not shown in event source responses.
     */
    @JvmName("mxaskhnvfchdvxuf")
    public suspend fun sharedAccessKey(`value`: Output<String>) {
        this.sharedAccessKey = value
    }

    /**
     * @param value Key-value pairs of additional properties for the resource.
     */
    @JvmName("illqhwakexslvfhu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ISO8601 UTC datetime with seconds precision (milliseconds are optional), specifying the date and time that will be the starting point for Events to be consumed.
     */
    @JvmName("hhugwntxoaunuijo")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
     */
    @JvmName("kxclwfpvhqwcieyl")
    public suspend fun timestampPropertyName(`value`: Output<String>) {
        this.timestampPropertyName = value
    }

    /**
     * @param value The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
     */
    @JvmName("bhpeuviqvoojvjwv")
    public suspend fun type(`value`: Output<Either<String, IngressStartAtType>>) {
        this.type = value
    }

    /**
     * @param value The name of the event hub's consumer group that holds the partitions from which events will be read.
     */
    @JvmName("usfburdupuagbnls")
    public suspend fun consumerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroupName = mapped
    }

    /**
     * @param value The name of the Time Series Insights environment associated with the specified resource group.
     */
    @JvmName("tjwswlshjjsuxuhy")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The name of the event hub.
     */
    @JvmName("iwnmpimxjjmbgurs")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value Name of the event source.
     */
    @JvmName("cstvvthaqbiemncj")
    public suspend fun eventSourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSourceName = mapped
    }

    /**
     * @param value The resource id of the event source in Azure Resource Manager.
     */
    @JvmName("diddfilqhhfktkri")
    public suspend fun eventSourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSourceResourceId = mapped
    }

    /**
     * @param value The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access policies for this key must grant 'Listen' permissions to the event hub.
     */
    @JvmName("gnfjlegmvrxfxgrp")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The kind of the event source.
     * Expected value is 'Microsoft.EventHub'.
     */
    @JvmName("mkuucjqtqhsbhvly")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
     */
    @JvmName("wlfknsnfadljrfhe")
    public suspend fun localTimestamp(`value`: LocalTimestampArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localTimestamp = mapped
    }

    /**
     * @param argument An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used and the corresponding timezone offset information. If a value isn't specified for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
     */
    @JvmName("cfquagsajuojgjlx")
    public suspend fun localTimestamp(argument: suspend LocalTimestampArgsBuilder.() -> Unit) {
        val toBeMapped = LocalTimestampArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localTimestamp = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("jrffdvhkdbgplnti")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("mtepxesgmmsuilvj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service bus that contains the event hub.
     */
    @JvmName("hjisoywjvpldbsea")
    public suspend fun serviceBusNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusNamespace = mapped
    }

    /**
     * @param value The value of the shared access key that grants the Time Series Insights service read access to the event hub. This property is not shown in event source responses.
     */
    @JvmName("fxcpbysfbmwcnmlq")
    public suspend fun sharedAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessKey = mapped
    }

    /**
     * @param value Key-value pairs of additional properties for the resource.
     */
    @JvmName("novqpcydkawjiejn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of additional properties for the resource.
     */
    @JvmName("ixyhvxwiuviwoooh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ISO8601 UTC datetime with seconds precision (milliseconds are optional), specifying the date and time that will be the starting point for Events to be consumed.
     */
    @JvmName("qtwjwatsatxigedx")
    public suspend fun time(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.time = mapped
    }

    /**
     * @param value The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName, or if null or empty-string is specified, the event creation time will be used.
     */
    @JvmName("ugnycjbtnqlpwati")
    public suspend fun timestampPropertyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestampPropertyName = mapped
    }

    /**
     * @param value The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
     */
    @JvmName("kxigwegggcuofhlv")
    public suspend fun type(`value`: Either<String, IngressStartAtType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
     */
    @JvmName("khaehuotsaduhlde")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IngressStartAtType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
     */
    @JvmName("wyyhngobkkqmmpck")
    public fun type(`value`: IngressStartAtType) {
        val toBeMapped = Either.ofRight<String, IngressStartAtType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EventHubEventSourceArgs = EventHubEventSourceArgs(
        consumerGroupName = consumerGroupName,
        environmentName = environmentName,
        eventHubName = eventHubName,
        eventSourceName = eventSourceName,
        eventSourceResourceId = eventSourceResourceId,
        keyName = keyName,
        kind = kind,
        localTimestamp = localTimestamp,
        location = location,
        resourceGroupName = resourceGroupName,
        serviceBusNamespace = serviceBusNamespace,
        sharedAccessKey = sharedAccessKey,
        tags = tags,
        time = time,
        timestampPropertyName = timestampPropertyName,
        type = type,
    )
}
