@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin

import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.ReferenceDataSetKeyPropertyResponse
import com.pulumi.azurenative.timeseriesinsights.kotlin.outputs.ReferenceDataSetKeyPropertyResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ReferenceDataSet].
 */
@PulumiTagMarker
public class ReferenceDataSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReferenceDataSetArgs = ReferenceDataSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReferenceDataSetArgsBuilder.() -> Unit) {
        val builder = ReferenceDataSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReferenceDataSet {
        val builtJavaResource =
            com.pulumi.azurenative.timeseriesinsights.ReferenceDataSet(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReferenceDataSet(builtJavaResource)
    }
}

/**
 * A reference data set provides metadata about the events in an environment. Metadata in the reference data set will be joined with events as they are read from event sources. The metadata that makes up the reference data set is uploaded or modified through the Time Series Insights data plane APIs.
 * Azure REST API version: 2020-05-15. Prior API version in Azure Native 1.x: 2020-05-15.
 * Other available API versions: 2017-11-15, 2021-06-30-preview.
 * ## Example Usage
 * ### ReferenceDataSetsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var referenceDataSet = new AzureNative.TimeSeriesInsights.ReferenceDataSet("referenceDataSet", new()
 *     {
 *         EnvironmentName = "env1",
 *         KeyProperties = new[]
 *         {
 *             new AzureNative.TimeSeriesInsights.Inputs.ReferenceDataSetKeyPropertyArgs
 *             {
 *                 Name = "DeviceId1",
 *                 Type = "String",
 *             },
 *             new AzureNative.TimeSeriesInsights.Inputs.ReferenceDataSetKeyPropertyArgs
 *             {
 *                 Name = "DeviceFloor",
 *                 Type = "Double",
 *             },
 *         },
 *         Location = "West US",
 *         ReferenceDataSetName = "rds1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/timeseriesinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timeseriesinsights.NewReferenceDataSet(ctx, "referenceDataSet", &timeseriesinsights.ReferenceDataSetArgs{
 * 			EnvironmentName: pulumi.String("env1"),
 * 			KeyProperties: []timeseriesinsights.ReferenceDataSetKeyPropertyArgs{
 * 				{
 * 					Name: pulumi.String("DeviceId1"),
 * 					Type: pulumi.String("String"),
 * 				},
 * 				{
 * 					Name: pulumi.String("DeviceFloor"),
 * 					Type: pulumi.String("Double"),
 * 				},
 * 			},
 * 			Location:             pulumi.String("West US"),
 * 			ReferenceDataSetName: pulumi.String("rds1"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.timeseriesinsights.ReferenceDataSet;
 * import com.pulumi.azurenative.timeseriesinsights.ReferenceDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var referenceDataSet = new ReferenceDataSet("referenceDataSet", ReferenceDataSetArgs.builder()
 *             .environmentName("env1")
 *             .keyProperties(
 *                 Map.ofEntries(
 *                     Map.entry("name", "DeviceId1"),
 *                     Map.entry("type", "String")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "DeviceFloor"),
 *                     Map.entry("type", "Double")
 *                 ))
 *             .location("West US")
 *             .referenceDataSetName("rds1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:timeseriesinsights:ReferenceDataSet rds1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TimeSeriesInsights/environments/{environmentName}/referenceDataSets/{referenceDataSetName}
 * ```
 */
public class ReferenceDataSet internal constructor(
    override val javaResource: com.pulumi.azurenative.timeseriesinsights.ReferenceDataSet,
) : KotlinCustomResource(javaResource, ReferenceDataSetMapper) {
    /**
     * The time the resource was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The reference data set key comparison behavior can be set using this property. By default, the value is 'Ordinal' - which means case sensitive key comparison will be performed while joining reference data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will be used.
     */
    public val dataStringComparisonBehavior: Output<String>?
        get() = javaResource.dataStringComparisonBehavior().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of key properties for the reference data set.
     */
    public val keyProperties: Output<List<ReferenceDataSetKeyPropertyResponse>>
        get() = javaResource.keyProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReferenceDataSetMapper : ResourceMapper<ReferenceDataSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.timeseriesinsights.ReferenceDataSet::class == javaResource::class

    override fun map(javaResource: Resource): ReferenceDataSet = ReferenceDataSet(
        javaResource as
            com.pulumi.azurenative.timeseriesinsights.ReferenceDataSet,
    )
}

/**
 * @see [ReferenceDataSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReferenceDataSet].
 */
public suspend fun referenceDataSet(
    name: String,
    block: suspend ReferenceDataSetResourceBuilder.() -> Unit,
): ReferenceDataSet {
    val builder = ReferenceDataSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReferenceDataSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun referenceDataSet(name: String): ReferenceDataSet {
    val builder = ReferenceDataSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
