@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.Gen2StorageConfigurationInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The storage configuration provides the connection details that allows the Time Series Insights service to connect to the customer storage account that is used to store the environment's data.
 * @property accountName The name of the storage account that will hold the environment's Gen2 data.
 * @property managementKey The value of the management key that grants the Time Series Insights service write access to the storage account. This property is not shown in environment responses.
 */
public data class Gen2StorageConfigurationInputArgs(
    public val accountName: Output<String>,
    public val managementKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.Gen2StorageConfigurationInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.timeseriesinsights.inputs.Gen2StorageConfigurationInputArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.Gen2StorageConfigurationInputArgs.builder()
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .managementKey(managementKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Gen2StorageConfigurationInputArgs].
 */
@PulumiTagMarker
public class Gen2StorageConfigurationInputArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var managementKey: Output<String>? = null

    /**
     * @param value The name of the storage account that will hold the environment's Gen2 data.
     */
    @JvmName("jovpgslebodddfpm")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The value of the management key that grants the Time Series Insights service write access to the storage account. This property is not shown in environment responses.
     */
    @JvmName("oiyugacimvmsshyx")
    public suspend fun managementKey(`value`: Output<String>) {
        this.managementKey = value
    }

    /**
     * @param value The name of the storage account that will hold the environment's Gen2 data.
     */
    @JvmName("oprxmgmwxmnxtsqe")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The value of the management key that grants the Time Series Insights service write access to the storage account. This property is not shown in environment responses.
     */
    @JvmName("bmkbnthprjxxctnd")
    public suspend fun managementKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managementKey = mapped
    }

    internal fun build(): Gen2StorageConfigurationInputArgs = Gen2StorageConfigurationInputArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        managementKey = managementKey ?: throw PulumiNullFieldException("managementKey"),
    )
}
