@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.SkuArgs.builder
import com.pulumi.azurenative.timeseriesinsights.kotlin.enums.SkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
 * @property capacity The capacity of the sku. For Gen1 environments, this value can be changed to support scale out of environments after they have been created.
 * @property name The name of this SKU.
 */
public data class SkuArgs(
    public val capacity: Output<Int>,
    public val name: Output<Either<String, SkuName>>,
) : ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.timeseriesinsights.inputs.SkuArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.SkuArgs.builder()
            .capacity(capacity.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, SkuName>>? = null

    /**
     * @param value The capacity of the sku. For Gen1 environments, this value can be changed to support scale out of environments after they have been created.
     */
    @JvmName("tsipmgmckfxtdqmp")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The name of this SKU.
     */
    @JvmName("wcbwrbyaxbgqpwet")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value The capacity of the sku. For Gen1 environments, this value can be changed to support scale out of environments after they have been created.
     */
    @JvmName("yrxnwhrjfguyiitg")
    public suspend fun capacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The name of this SKU.
     */
    @JvmName("hixihpvaqmxbhpcw")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of this SKU.
     */
    @JvmName("wwjqsmxegcdwykfd")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of this SKU.
     */
    @JvmName("fmkglogcdwidpctm")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity ?: throw PulumiNullFieldException("capacity"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
