@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.inputs

import com.pulumi.azurenative.timeseriesinsights.inputs.WarmStoreConfigurationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's data available for faster query.
 * @property dataRetention ISO8601 timespan specifying the number of days the environment's events will be available for query from the warm store.
 */
public data class WarmStoreConfigurationPropertiesArgs(
    public val dataRetention: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.timeseriesinsights.inputs.WarmStoreConfigurationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.timeseriesinsights.inputs.WarmStoreConfigurationPropertiesArgs =
        com.pulumi.azurenative.timeseriesinsights.inputs.WarmStoreConfigurationPropertiesArgs.builder()
            .dataRetention(dataRetention.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WarmStoreConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class WarmStoreConfigurationPropertiesArgsBuilder internal constructor() {
    private var dataRetention: Output<String>? = null

    /**
     * @param value ISO8601 timespan specifying the number of days the environment's events will be available for query from the warm store.
     */
    @JvmName("pqxwofppnhbqggca")
    public suspend fun dataRetention(`value`: Output<String>) {
        this.dataRetention = value
    }

    /**
     * @param value ISO8601 timespan specifying the number of days the environment's events will be available for query from the warm store.
     */
    @JvmName("ggmfnrgcicgbfqra")
    public suspend fun dataRetention(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataRetention = mapped
    }

    internal fun build(): WarmStoreConfigurationPropertiesArgs = WarmStoreConfigurationPropertiesArgs(
        dataRetention = dataRetention ?: throw PulumiNullFieldException("dataRetention"),
    )
}
