@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An object that represents the offset information for the local timestamp format specified. Should not be specified for LocalTimestampFormat - Embedded.
 * @property propertyName The event property that will be contain the offset information to calculate the local timestamp. When the LocalTimestampFormat is Iana, the property name will contain the name of the column which contains IANA Timezone Name (eg: Americas/Los Angeles). When LocalTimestampFormat is Timespan, it contains the name of property which contains values representing the offset (eg: P1D or 1.00:00:00)
 */
public data class LocalTimestampResponseTimeZoneOffset(
    public val propertyName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.LocalTimestampResponseTimeZoneOffset):
            LocalTimestampResponseTimeZoneOffset = LocalTimestampResponseTimeZoneOffset(
            propertyName = javaType.propertyName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
