@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.timeseriesinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines the capacity of the environment, the ingress rate, and the billing rate.
 * @property capacity The capacity of the sku. For Gen1 environments, this value can be changed to support scale out of environments after they have been created.
 * @property name The name of this SKU.
 */
public data class SkuResponse(
    public val capacity: Int,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.timeseriesinsights.outputs.SkuResponse):
            SkuResponse = SkuResponse(
            capacity = javaType.capacity(),
            name = javaType.name(),
        )
    }
}
