@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.videoanalyzer.kotlin

import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoArchivalResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoContentUrlsResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoFlagsResponse
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoMediaInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoArchivalResponse.Companion.toKotlin as videoArchivalResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoContentUrlsResponse.Companion.toKotlin as videoContentUrlsResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoFlagsResponse.Companion.toKotlin as videoFlagsResponseToKotlin
import com.pulumi.azurenative.videoanalyzer.kotlin.outputs.VideoMediaInfoResponse.Companion.toKotlin as videoMediaInfoResponseToKotlin

/**
 * Builder for [Video].
 */
@PulumiTagMarker
public class VideoResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VideoArgs = VideoArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VideoArgsBuilder.() -> Unit) {
        val builder = VideoArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Video {
        val builtJavaResource = com.pulumi.azurenative.videoanalyzer.Video(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Video(builtJavaResource)
    }
}

/**
 * Represents a video resource within Azure Video Analyzer. Videos can be ingested from RTSP cameras through live pipelines or can be created by exporting sequences from existing captured video through a pipeline job. Videos ingested through live pipelines can be streamed through Azure Video Analyzer Player Widget or compatible players. Exported videos can be downloaded as MP4 files.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-05-01-preview.
 * Other available API versions: 2021-05-01-preview.
 * ## Example Usage
 * ### Register video entity.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var video = new AzureNative.VideoAnalyzer.Video("video", new()
 *     {
 *         AccountName = "testaccount2",
 *         Description = "Sample Description 1",
 *         ResourceGroupName = "testrg",
 *         Title = "Sample Title 1",
 *         VideoName = "video1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/videoanalyzer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videoanalyzer.NewVideo(ctx, "video", &videoanalyzer.VideoArgs{
 * 			AccountName:       pulumi.String("testaccount2"),
 * 			Description:       pulumi.String("Sample Description 1"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Title:             pulumi.String("Sample Title 1"),
 * 			VideoName:         pulumi.String("video1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.videoanalyzer.Video;
 * import com.pulumi.azurenative.videoanalyzer.VideoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var video = new Video("video", VideoArgs.builder()
 *             .accountName("testaccount2")
 *             .description("Sample Description 1")
 *             .resourceGroupName("testrg")
 *             .title("Sample Title 1")
 *             .videoName("video1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:videoanalyzer:Video video1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/videos/{videoName}
 * ```
 */
public class Video internal constructor(
    override val javaResource: com.pulumi.azurenative.videoanalyzer.Video,
) : KotlinCustomResource(javaResource, VideoMapper) {
    /**
     * Video archival properties.
     */
    public val archival: Output<VideoArchivalResponse>?
        get() = javaResource.archival().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    videoArchivalResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Set of URLs to the video content.
     */
    public val contentUrls: Output<VideoContentUrlsResponse>
        get() = javaResource.contentUrls().applyValue({ args0 ->
            args0.let({ args0 ->
                videoContentUrlsResponseToKotlin(args0)
            })
        })

    /**
     * Optional video description provided by the user. Value can be up to 2048 characters long.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Video flags contain information about the available video actions and its dynamic properties based on the current video state.
     */
    public val flags: Output<VideoFlagsResponse>
        get() = javaResource.flags().applyValue({ args0 ->
            args0.let({ args0 ->
                videoFlagsResponseToKotlin(args0)
            })
        })

    /**
     * Contains information about the video and audio content.
     */
    public val mediaInfo: Output<VideoMediaInfoResponse>?
        get() = javaResource.mediaInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    videoMediaInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Optional video title provided by the user. Value can be up to 256 characters long.
     */
    public val title: Output<String>?
        get() = javaResource.title().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VideoMapper : ResourceMapper<Video> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.videoanalyzer.Video::class == javaResource::class

    override fun map(javaResource: Resource): Video = Video(
        javaResource as
            com.pulumi.azurenative.videoanalyzer.Video,
    )
}

/**
 * @see [Video].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Video].
 */
public suspend fun video(name: String, block: suspend VideoResourceBuilder.() -> Unit): Video {
    val builder = VideoResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Video].
 * @param name The _unique_ name of the resulting resource.
 */
public fun video(name: String): Video {
    val builder = VideoResourceBuilder()
    builder.name(name)
    return builder.build()
}
